<?php

ini_set('memory_limit', -1);
require_once("../main_includes/init.php");

require('fpdf/fpdf.php');
// include('../includes/configpdo.php');

if (!isset($_GET['record'], $_SESSION['user_id'], $_GET['service_id'])) {
    redirect("../");
}

$user = User::find_by_id($_SESSION['user_id']);
if (!$user) {
    redirect("../");
}

$sub_service = SubService::find_by_id($_GET['service_id']);
if (!$sub_service) {
    redirect("../");
}

// echo '<pre>';
// print_r($sub_service);
// echo '</pre>';

$service_fee = intval($sub_service->service_fee);
$status = 1;
$service = $sub_service->service_name;

$my_wallet = Wallet::find_by_query("SELECT * FROM wallet WHERE user_id =" . $user->id . " LIMIT 1");
$my_wallet = array_shift($my_wallet);
$my_wallet_balance = intval($my_wallet->balance);

// if ($my_wallet_balance < $service_fee) {
//     redirect("../");
//     return false;
// }

$service_record = ServiceRecord::find_by_id($_GET['record']);
if (!$service_record) {

    redirect("../");
    return false;
}


$in_transaction = new InTransaction;

// $new_wallet_balance = $my_wallet_balance  - $service_fee;
// $my_wallet->balance = $new_wallet_balance;
// $my_wallet->date_updated = $date;
// $my_wallet->save();

$in_transaction->user_id = $user->id;
$in_transaction->wallet_id = $my_wallet->id;
$in_transaction->amount = $service_fee;
$in_transaction->remaining_balance = $my_wallet_balance;
$in_transaction->service_id = intval($sub_service->service_id);
$in_transaction->service = $service;
$in_transaction->date = $status == 1 ? $date : $in_transaction->date;
$in_transaction->status = $status;
$in_transaction->record_id = $service_record->id;
$in_transaction->search_query = $service_record->search_query;

// echo '<pre>';
// print_r($in_transaction);
// echo '</pre>';

if (!isset($_GET['redownload'])) {
    $in_transaction->save();
}

$response_std = json_decode($service_record->response);

// echo "<pre>";
// print_r($response_std->nin_data->residence_Town);
// echo "</pre>";
// return false;

// $nin = $response_std->nin_data->nin;
$nin = $response_std->nin_data->nin != '' ? $response_std->nin_data->nin : $service_record->search_query;


$sub1 = substr($nin, 0, 4);
$sub2 = substr($nin, 4, 3);
$sub3 = substr($nin, 7, 4);



class PDF extends FPDF
{

    function Header()
    {
        // Select Arial bold 15
        $this->SetFont('Arial', 'B', 18);
        $this->SetTextColor(0);
        $this->SetDrawColor(0, 0, 155);
        $this->Ln(20);

        $this->SetFont('Arial', 'B', 14);
        $this->SetFont('Arial', '', 12);

        $this->SetTextColor(50, 50, 50);

        $this->Image('nin_slip.jpg', 7, 5.5, 195.5);
        // Line break 
        // $this->Ln(2);
    }
    function Footer()
    {
        // Go to 0.9 cm from bottom
        // $this->SetY(-9);
        // $this->SetFont('Arial', 'I', 8);
        // Print centered page number
        // $this->Cell(0, 10, 'Page ' . $this->PageNo(), 0, 0, 'C');
    }
}



// $filename = './tmp/t' . rand(00000000, 99999999) . '.jpeg';
// if (file_exists($filename)) {
//     unlink($filename);
// }
// $img_o = base64_decode($response_std->nin_data->photo);
// $img =  imagecreatefromstring($img_o);
// imagejpeg($img, $filename);



$pdf = new PDF();



$pdf->AliasNbPages();
$pdf->AddPage('P', 'A4');
$pdf->SetFont('', '', 10);
$pdf->SetFillColor(255, 255, 255);
if ($response_std->nin_data->photo != '') {


    $filename = './tmp/t' . rand(00000000, 99999999) . '.jpeg';
    if (file_exists($filename)) {
        unlink($filename);
    }
    $img_o = base64_decode($response_std->nin_data->photo);
    $img =  imagecreatefromstring($img_o);
    imagejpeg($img, $filename);
    $pdf->Image($filename, 172.5, 27.5, 28);
}
// $pdf->Ln(6);
$pdf->SetDrawColor(150, 150, 150);
$pdf->SetFont('Arial', '', 7.5);

$pdf->SetTextColor(0);

$pdf->Cell(18, 5, "", 0, 0, "L");
$pdf->Cell(50, 5, $response_std->nin_data->trackingId, 0, 0, "L");
$pdf->Cell(50, 5, $response_std->nin_data->surname != "****" ? $response_std->nin_data->surname : '', 0, 1, "L");

$pdf->Ln(6);
$pdf->Cell(18, 5, "", 0, 0, "L");
$pdf->Cell(50, 5, $nin, 0, 0, "L");
$pdf->Cell(50, 5, $response_std->nin_data->firstname, 0, 1, "L");

$pdf->Ln(5);
$pdf->Cell(23, 5, "", 0, 0, "L");
$pdf->Cell(45, 5, '', 0, 0, "L");
$pdf->Cell(50, 5, $response_std->nin_data->middlename != "****" ? $response_std->nin_data->middlename : '', 0, 1, "L");

$pdf->Ln(3);
$pdf->Cell(23, 5, "", 0, 0, "L");
$pdf->Cell(45, 5, "", 0, 0, "L");
$pdf->Cell(50, 5, strtoupper($response_std->nin_data->gender), 0, 1, "L");

$pdf->SetXY(120, 35);
$pdf->MultiCell(39, 3.5, $response_std->nin_data->residence_address ??  $response_std->nin_data->residence_AdressLine1, 0, 1, "L", false);

$pdf->SetXY(120, 57);
$pdf->MultiCell(39, 4, $response_std->nin_data->residence_town ?? $response_std->nin_data->residence_Town. "\n" . strtoupper($response_std->nin_data->residence_state), 0, 1, "L", false);


// $pdf->MultiCell(0, 5, 'NOTE: The National Identification Number (NIN) is your identity. It is confidential and may only be released for legitimate transaction..', 0, 1, 'C', true);
if ($response_std->nin_data->photo != '') {
    if (file_exists($filename)) {
        unlink($filename);
    }
}


// $pdf->Output();
$doc_name = $nin . "_regular_nin_slip.pdf";
$pdf->Output("D", $doc_name);