

<div class="p-2 sm:ml-64 mb-14">
    <nav class="md:max-w-max flex px-5 py-2 mt-20 mx-2 text-cyan-700 border border-cyan-200 rounded-lg bg-cyan-50 dark:bg-cyan-800 dark:border-cyan-700"
        aria-label="Breadcrumb">
        <ol class="inline-flex items-center space-x-1 md:space-x-3">
            <li class="inline-flex items-center">
                <a href="<?= BASE_URL ?>"
                    class="inline-flex items-center text-sm font-medium text-gray-700 hover:text-blue-600 dark:text-gray-400 dark:hover:text-white">
                    <svg class="w-3 h-3 mr-2.5" aria-hidden="true" xmlns="http://www.w3.org/2000/svg"
                        fill="currentColor" viewBox="0 0 20 20">
                        <path
                            d="m19.707 9.293-2-2-7-7a1 1 0 0 0-1.414 0l-7 7-2 2a1 1 0 0 0 1.414 1.414L2 10.414V18a2 2 0 0 0 2 2h3a1 1 0 0 0 1-1v-4a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1v4a1 1 0 0 0 1 1h3a2 2 0 0 0 2-2v-7.586l.293.293a1 1 0 0 0 1.414-1.414Z" />
                    </svg>
                    Home
                </a>
            </li>

            <li>
                <div class="flex items-center">
                    <svg class="w-3 h-3 mx-1 text-gray-400" aria-hidden="true" xmlns="http://www.w3.org/2000/svg"
                        fill="none" viewBox="0 0 6 10">
                        <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="m1 9 4-4-4-4" />
                    </svg>
                    <a href="#"
                        class="ml-1 text-sm font-medium text-gray-700 hover:text-blue-600 md:ml-2 dark:text-gray-400 dark:hover:text-white">TXN
                        History</a>
                </div>
            </li>

        </ol>
    </nav>

        <div
            class="relative flex flex-col m-2 h-full min-w-0 break-words bg-sky-800 border-0 shadow-soft-xl rounded bg-clip-border">
            <div
                class="relative flex flex-col min-w-0 break-words bg-sky-800 border-0 shadow-soft-xl rounded bg-clip-border">
                <div class="p-6 px-4 pb-0 mb-0 bg-sky-800 border-b-0 rounded">
                    <h6 class="mb-0 text-sm text-white">All Recent Services Perform</h6>
                </div>
                <div class="flex-auto p-4 pt-6 text-white">
                    <hr class="h-px bg-transparent bg-gradient-to-r from-transparent via-black/40 to-transparent" />
                    <!-- </div> -->
                    <div class="table-responsive" style="font-size: 12px !important;">

                        <table class="table table-flush datatable text-sm text-white overflow-x-scroll" datatable
                            id="datatable-search">
                            <thead class="thead-light">
                                <tr>
                                    <th>#</th>
                                    <th>User</th>
                                    <th>Service type</th>
                                    <th>Amount</th>
                                    <th>Searching Query</th>
                                    <th>Status</th>
                                    <th>Date</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $my_intransaction = InTransaction::find_all();
                                $my_intransaction = array_reverse($my_intransaction);

                                $i = 1;
                                foreach ($my_intransaction as $intransaction):
                                    ?>
                                    <tr class='hover:bg-sky-400 hover:text-sky-950'>
                                        <td>
                                            <?= $i ?>
                                        </td>
                                        <td>
                                            <?= User::find_by_id($intransaction->user_id)->email ?>
                                        </td>
                                        <td>
                                            <?= $intransaction->service ?>
                                        </td>
                                        <td>₦
                                            <?= $intransaction->amount ?>
                                        </td>
                                        <td>
                                            <?= $intransaction->search_query ?>
                                        </td>
                                        <td>
                                            <?= $intransaction->status == 1 ? '<span class="badge badge-lg bg-gradient-to-tl from-green-600 to-lime-400">Successful</span>' : '<span
                                        class="badge badge-lg bg-gradient-to-tl from-red-600 to-rose-400">Failed</span>' ?>
                                        </td>
                                        <td>
                                            <?= $intransaction->date ?>
                                        </td>

                                    </tr>
                                    <?php $i++;
                                endforeach; ?>
                            <tbody>
                        </table>
                    </div>
                </div>
            </div>

        </div>
        <div
            class="relative flex flex-col m-2 h-full min-w-0 break-words bg-sky-800 border-0 shadow-soft-xl rounded bg-clip-border">
            <div
                class="relative flex flex-col min-w-0 break-words bg-sky-800 border-0 shadow-soft-xl rounded bg-clip-border">
                <div class="p-6 px-4 pb-0 mb-0 bg-sky-800 border-b-0 rounded">
                    <h6 class="mb-0 text-sm text-white">All Recent Payments Perform</h6>
                </div>
                <div class="flex-auto p-4 pt-6 text-white">
                    <hr class="h-px bg-transparent bg-gradient-to-r from-transparent via-black/40 to-transparent" />
                    <!-- </div> -->
                    <div class="table-responsive" style="font-size: 12px !important;">

                        <table class="table table-flush datatable text-sm text-white overflow-x-scroll" datatable
                            id="datatable-search">
                            <thead class="thead-light">
                                <tr>
                                    <th>#</th>
                                    <th>ID</th>
                                    <th>User ID</th>
                                    <th>Amount</th>
                                    <th>Method</th>
                                    <th>Ref</th>
                                    <th>Date</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $i = 1;
                                $his_payments = Payment::find_all();
                                $his_payments = array_reverse($his_payments);
                                foreach ($his_payments as $his_payment):
                                    ?>
                                    <tr class='hover:bg-sky-400 hover:text-sky-950'>
                                        <td>
                                            <?= $i ?>
                                        </td>
                                        <td>
                                            <?= $his_payment->id ?>
                                        </td>
                                        <td>
                                            <?= User::find_by_id($his_payment->user_id)->email ?>
                                        </td>
                                        <td>₦
                                            <?= $his_payment->amount ?>
                                        </td>
                                        <td>
                                            <?= $his_payment->method ?>
                                        </td>
                                        <td>
                                            <?= $his_payment->reference ?>
                                        </td>
                                        <td>
                                            <?= $his_payment->date_created ?>
                                        </td>

                                    </tr>
                                    <?php $i++;
                                endforeach; ?>
                            <tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <div
            class="relative flex flex-col m-2 h-full min-w-0 break-words bg-sky-800 border-0 shadow-soft-xl rounded bg-clip-border">
            <div
                class="relative flex flex-col min-w-0 break-words bg-sky-800 border-0 shadow-soft-xl rounded bg-clip-border">
                <div class="p-6 px-4 pb-0 mb-0 bg-sky-800 border-b-0 rounded">
                    <h6 class="mb-0 text-sm text-white">All Initialized Transactions</h6>
                </div>
                <div class="flex-auto p-4 pt-6 text-white">
                    <hr class="h-px bg-transparent bg-gradient-to-r from-transparent via-black/40 to-transparent" />
                    <!-- </div> -->
                    <div class="table-responsive" style="font-size: 12px !important;">

                        <table class="table table-flush datatable text-sm text-white overflow-x-scroll" datatable
                            id="datatable-search">
                            <thead class="thead-light">
                                <tr>
                                    <th>#</th>
                                    <th>ID</th>
                                    <th>Amount</th>
                                    <th>Method</th>
                                    <th>Ref</th>
                                    <th>Status</th>
                                    <th>Date Created</th>
                                    <th>Date Updated</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $i = 1;
                                $his_transactions = MyTransaction::find_all();

                                foreach ($his_transactions as $his_transaction):
                                    ?>
                                    <tr class='hover:bg-sky-400 hover:text-sky-950'>
                                        <td>
                                            <?= $i ?>
                                        </td>
                                        <td>
                                            <?= $his_transaction->id ?>
                                        </td>
                                        <td>₦
                                            <?= $his_transaction->amount ?>
                                        </td>
                                        <td>
                                            <?= $his_transaction->method ?>
                                        </td>
                                        <td>
                                            <?= $his_transaction->reference ?>
                                        </td>
                                        <td>
                                            <?= $his_transaction->status == 'Paid' ? '<span class="badge badge-lg bg-gradient-to-tl from-green-600 to-lime-400">Verified</span>' : '<span
                                        class="badge badge-lg bg-gradient-to-tl from-red-600 to-rose-400">Not Paid</span>' ?>
                                        </td>
                                        <td>
                                            <?= $his_transaction->date_created ?>
                                        </td>
                                        <td>
                                            <?= $his_transaction->date_updated ?>
                                        </td>

                                    </tr>
                                    <?php $i++;
                                endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>


        

</div>
<!-- <script>
    function mama() {

        var amount = parseInt($('#amount').val())
        console.log(amount)
        if (!isNaN(amount)) {
            if (amount < 500) {

                $('#pay_btn').prop('disabled', true)
            } else {
                $('#pay_btn').prop('disabled', false)

            }
        } else {

            $('#pay_btn').prop('disabled', true)
        }


    }


    $(function () {

        /* Instantiating iziModal */
        $("#top-up-modal").iziModal({
            overlayClose: false,
            overlayColor: 'rgba(0, 0, 0, 0.6)',
            background: null,
            headerColor: '#344767',
            title: 'Wallet Top-up',
            subtitle: 'Minimun Top-up Amount is ₦500',
            theme: 'dark',
            borderBottom: true,
            radius: 15,
            focusInput: true,
        });
    })



    $(document).ready(function () {
        $("#edit_profile_btn").click(function () {
            $("#save_btn").css({
                "display": ""
            })

            $(this).hide()


            $("#address").prop("disabled", false)
            $("#password").prop("disabled", false)
            $("#confirm_pass").prop("disabled", false)

        })
    })


    $(document).on("submit", "#update_profile_form", function (e) {

        e.preventDefault()
        var address = $("#address").val()
        var password = $("#password").val()
        var confirm_pass = $("#confirm_pass").val()
        var user_id = $("#user_id").val()

        if (user_id == '') {

            return false
        }

        if (address == "") {
            iziToast.show({
                title: 'Error!',
                message: "Address Field Cannot be Empty",
                color: "yellow",
                position: "topRight",
                balloon: true
            });

            return false
        }

        if (password.length < 6) {

            iziToast.show({
                title: 'Error!',
                message: "Password length must be at least 6 characters",
                color: "yellow",
                position: "topRight",
                balloon: true
            });

            return false
        }
        if (confirm_pass != password) {

            iziToast.show({
                title: 'Error!',
                message: "Password do not match",
                color: "yellow",
                position: "topRight",
                balloon: true
            });


            return false
        }

        $.ajax({
            method: "POST",
            dataType: 'json',
            url: "../main_includes/components/save_profile.php",
            data: $(this).serialize(),
            success: function (response) {
                // console.log(response)
                if (response.response_code == "00") {

                    iziToast.show({
                        title: 'Done!',
                        message: "Profile Updated Successfuly",
                        color: "green",
                        position: "center",
                        balloon: true
                    });


                } else {

                    iziToast.show({
                        title: 'Error!',
                        message: response.message,
                        color: "red",
                        position: "topRight",
                        balloon: true
                    });

                }
            },
            error: function (error) {
                // console.log(error)
                if (error) {
                    var res = JSON.parse(error.responseText)

                    iziToast.show({
                        title: 'Error!',
                        message: res.message,
                        color: "red",
                        position: "topRight",
                        balloon: true
                    });

                }
            }
        }).done(function () {
            $("#save_btn").css({
                "display": "none"
            })

            $("#edit_profile_btn").show()

            $("#address").prop("disabled", true)
            $("#password").prop("disabled", true)
            $("#confirm_pass").prop("disabled", true)

        })



    })
</script> -->
