<!-- <div class="ease-soft-in-out xl:ml-68.5 relative h-full max-h-screen bg-gray-50 transition-all duration-200"> -->
<nav class="absolute z-20 flex flex-wrap items-center justify-between w-full px-12 text-white transition-all shadow-none duration-250 ease-soft-in lg:flex-nowrap lg:justify-start"
    navbar-profile navbar-scroll="true">
    <div class="flex items-center justify-between w-full px-6 py-2 mx-auto flex-wrap-inherit">
        <nav>
            <!-- breadcrumb -->
            <ol class="flex flex-wrap pt-1 pl-2 pr-4 mr-12 bg-transparent rounded-lg sm:mr-16">
                <li class="leading-normal text-sm">
                    <a class="opacity-50" href="javascript:;">Pages</a>
                </li>
                <li class="text-sm pl-2 capitalize leading-normal before:float-left before:pr-2 before:content-['/']"
                    aria-current="page">Profile</li>
            </ol>
            <h6 class="mb-2 ml-2 font-bold text-white capitalize">Profile</h6>
        </nav>

        <div class="flex items-center mt-2 grow sm:mt-0 sm:mr-6 md:mr-0 lg:flex lg:basis-auto">
            <div class="flex items-center md:ml-auto md:pr-4">
                <div class="relative flex flex-wrap items-stretch w-full transition-all rounded-lg ease-soft">
                    <span
                        class="text-sm ease-soft leading-5.6 absolute z-50 -ml-px flex h-full items-center whitespace-nowrap rounded-lg rounded-tr-none rounded-br-none border border-r-0 border-transparent bg-transparent py-2 px-2.5 text-center font-normal text-slate-500 transition-all">
                        <i class="fas fa-search" aria-hidden="true"></i>
                    </span>
                    <input type="text"
                        class="pl-8.75 text-sm focus:shadow-soft-primary-outline ease-soft w-1/100 leading-5.6 relative -ml-px block min-w-0 flex-auto rounded-lg border border-solid border-gray-300 bg-white bg-clip-padding py-2 pr-3 text-gray-700 transition-all placeholder:text-gray-500 focus:border-fuchsia-300 focus:outline-none focus:transition-shadow"
                        placeholder="Type here..." />
                </div>
            </div>
            <ul class="flex flex-row justify-end pl-0 mb-0 list-none md-max:w-full">

                <li class="flex items-center">
                    <a href="../sign-out"
                        class="block px-0 py-2 font-semibold text-white transition-all ease-soft-in-out text-sm">
                        <i class="fa fa-user sm:mr-1" aria-hidden="true"></i>
                        <span class="hidden sm:inline">Sign Out</span>
                    </a>
                </li>
                <li class="flex items-center pl-4 xl:hidden">
                    <a href="javascript:;" class="block p-0 text-white transition-all ease-soft-in-out text-sm"
                        sidenav-trigger>
                        <div class="w-4.5 overflow-hidden">
                            <i class="ease-soft mb-0.75 relative block h-0.5 rounded-sm bg-white transition-all"></i>
                            <i class="ease-soft mb-0.75 relative block h-0.5 rounded-sm bg-white transition-all"></i>
                            <i class="ease-soft relative block h-0.5 rounded-sm bg-white transition-all"></i>
                        </div>
                    </a>
                </li>
                <li class="flex items-center px-4">
                    <a href="javascript:;" class="p-0 text-white transition-all text-sm ease-soft-in-out">
                        <i fixed-plugin-button-nav class="cursor-pointer fa fa-cog" aria-hidden="true"></i>
                        <!-- fixed-plugin-button-nav  -->
                    </a>
                </li>

                <!-- notifications -->


            </ul>
        </div>
    </div>
</nav>

<div class="w-full px-6 mx-auto">
    <div class="relative flex items-center p-0 mt-2 overflow-hidden bg-center bg-cover min-h-75 rounded-2xl"
        style="background-image: url('../assets/img/curved-images/curved0.jpg'); background-position-y: 50%">
        <span
            class="absolute inset-y-0 w-full h-full bg-center bg-cover bg-gradient-to-tl from-purple-700 to-pink-500 opacity-60"></span>
    </div>
    <div
        class="relative flex flex-col flex-auto min-w-0 p-4 mx-6 -mt-16 overflow-hidden break-words border-0 shadow-blur rounded-2xl bg-white/80 bg-clip-border backdrop-blur-2xl backdrop-saturate-200">
        <div class="flex flex-wrap -mx-3">
            <div class="flex-none w-auto max-w-full px-3">
                <div
                    class="text-base ease-soft-in-out h-18.5 w-18.5 relative inline-flex items-center justify-center rounded-xl text-white transition-all duration-200">
                    <img src="../assets/img/bruce-mars.jpg" alt="profile_image"
                        class="w-full shadow-soft-sm rounded-xl" />
                </div>
            </div>
            <div class="flex-none w-auto max-w-full px-3 my-auto">
                <div class="h-full">
                    <h5 class="mb-1">
                        <?= strtoupper($user->first_name . " " . $user->last_name) ?>

                    </h5>
                    <p class="mb-0 font-semibold leading-normal text-sm">Administrator</p>
                </div>
            </div>
            <div class="w-full max-w-full px-3 mx-auto mt-4 sm:my-auto sm:mr-0 md:w-1/2 md:flex-none lg:w-4/12">
                <div class="relative right-0">
                    <ul class="relative flex flex-wrap p-1 list-none bg-transparent rounded-xl" nav-pills
                        role="tablist">

                        <li class="z-30 flex-auto text-center">
                            <a class="z-30 block w-full px-0 py-1 mb-0 transition-colors border-0 rounded-lg ease-soft-in-out bg-inherit text-slate-700"
                                nav-link href="javascript:;" role="tab" aria-selected="false">
                                <svg class="text-slate-700" width="16px" height="16px" viewBox="0 0 40 40" version="1.1"
                                    xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
                                    <title>settings</title>
                                    <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                        <g transform="translate(-2020.000000, -442.000000)" fill="#FFFFFF"
                                            fill-rule="nonzero">
                                            <g transform="translate(1716.000000, 291.000000)">
                                                <g transform="translate(304.000000, 151.000000)">
                                                    <polygon class="fill-slate-800" opacity="0.596981957"
                                                        points="18.0883333 15.7316667 11.1783333 8.82166667 13.3333333 6.66666667 6.66666667 0 0 6.66666667 6.66666667 13.3333333 8.82166667 11.1783333 15.315 17.6716667">
                                                    </polygon>
                                                    <path class="fill-slate-800"
                                                        d="M31.5666667,23.2333333 C31.0516667,23.2933333 30.53,23.3333333 30,23.3333333 C29.4916667,23.3333333 28.9866667,23.3033333 28.48,23.245 L22.4116667,30.7433333 L29.9416667,38.2733333 C32.2433333,40.575 35.9733333,40.575 38.275,38.2733333 L38.275,38.2733333 C40.5766667,35.9716667 40.5766667,32.2416667 38.275,29.94 L31.5666667,23.2333333 Z"
                                                        opacity="0.596981957"></path>
                                                    <path class="fill-slate-800"
                                                        d="M33.785,11.285 L28.715,6.215 L34.0616667,0.868333333 C32.82,0.315 31.4483333,0 30,0 C24.4766667,0 20,4.47666667 20,10 C20,10.99 20.1483333,11.9433333 20.4166667,12.8466667 L2.435,27.3966667 C0.95,28.7083333 0.0633333333,30.595 0.00333333333,32.5733333 C-0.0583333333,34.5533333 0.71,36.4916667 2.11,37.89 C3.47,39.2516667 5.27833333,40 7.20166667,40 C9.26666667,40 11.2366667,39.1133333 12.6033333,37.565 L27.1533333,19.5833333 C28.0566667,19.8516667 29.01,20 30,20 C35.5233333,20 40,15.5233333 40,10 C40,8.55166667 39.685,7.18 39.1316667,5.93666667 L33.785,11.285 Z">
                                                    </path>
                                                </g>
                                            </g>
                                        </g>
                                    </g>
                                </svg>
                                <span class="ml-1">Settings</span>
                            </a>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="w-full p-6 mx-auto">
    <div class="flex flex-wrap -mx-3">
        <div class="w-full max-w-full px-3 xl:w-1/2">
            <div
                class="relative flex flex-col h-full min-w-0 break-words bg-white border-0 shadow-soft-xl rounded-2xl bg-clip-border">
                <div class="p-4 pb-0 mb-0 bg-white border-b-0 rounded-t-2xl">
                    <h6 class="mb-0">Platform Settings</h6>
                </div>
                <div class="flex-auto p-4">


                    <h6 class="mt-6 font-bold leading-tight uppercase text-xs text-slate-500">Application</h6>
                    <ul class="flex flex-col pl-0 mb-0 rounded-lg">
                        <li class="relative block px-0 py-2 bg-white border-0 rounded-t-lg text-inherit">
                            <div class="min-h-6 mb-0.5 block pl-0">
                                <input id="launches projects"
                                    class="mt-0.54 rounded-10 duration-250 ease-soft-in-out after:rounded-circle after:shadow-soft-2xl after:duration-250 checked:after:translate-x-5.25 h-5 relative float-left ml-auto w-10 cursor-pointer appearance-none border border-solid border-gray-200 bg-slate-800/10 bg-none bg-contain bg-left bg-no-repeat align-top transition-all after:absolute after:top-px after:h-4 after:w-4 after:translate-x-px after:bg-white after:content-[''] checked:border-slate-800/95 checked:bg-slate-800/95 checked:bg-none checked:bg-right"
                                    type="checkbox" />
                                <label for="launches projects"
                                    class="w-4/5 mb-0 ml-4 overflow-hidden font-normal cursor-pointer select-none text-sm text-ellipsis whitespace-nowrap text-slate-500"
                                    for="flexSwitchCheckDefault3">New launches and projects</label>
                            </div>
                        </li>
                        <li class="relative block px-0 py-2 bg-white border-0 text-inherit">
                            <div class="min-h-6 mb-0.5 block pl-0">
                                <input id="product updates"
                                    class="mt-0.54 rounded-10 duration-250 ease-soft-in-out after:rounded-circle after:shadow-soft-2xl after:duration-250 checked:after:translate-x-5.25 h-5 relative float-left ml-auto w-10 cursor-pointer appearance-none border border-solid border-gray-200 bg-slate-800/10 bg-none bg-contain bg-left bg-no-repeat align-top transition-all after:absolute after:top-px after:h-4 after:w-4 after:translate-x-px after:bg-white after:content-[''] checked:border-slate-800/95 checked:bg-slate-800/95 checked:bg-none checked:bg-right"
                                    type="checkbox" checked />
                                <label for="product updates"
                                    class="w-4/5 mb-0 ml-4 overflow-hidden font-normal cursor-pointer select-none text-sm text-ellipsis whitespace-nowrap text-slate-500"
                                    for="flexSwitchCheckDefault4">Monthly product updates</label>
                            </div>
                        </li>
                        <li class="relative block px-0 py-2 pb-0 bg-white border-0 rounded-b-lg text-inherit">
                            <div class="min-h-6 mb-0.5 block pl-0">
                                <input id="subscribe"
                                    class="mt-0.54 rounded-10 duration-250 ease-soft-in-out after:rounded-circle after:shadow-soft-2xl after:duration-250 checked:after:translate-x-5.25 h-5 relative float-left ml-auto w-10 cursor-pointer appearance-none border border-solid border-gray-200 bg-slate-800/10 bg-none bg-contain bg-left bg-no-repeat align-top transition-all after:absolute after:top-px after:h-4 after:w-4 after:translate-x-px after:bg-white after:content-[''] checked:border-slate-800/95 checked:bg-slate-800/95 checked:bg-none checked:bg-right"
                                    type="checkbox" />
                                <label for="subscribe"
                                    class="w-4/5 mb-0 ml-4 overflow-hidden font-normal cursor-pointer select-none text-sm text-ellipsis whitespace-nowrap text-slate-500"
                                    for="flexSwitchCheckDefault5">Subscribe to newsletter</label>
                            </div>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
        <div class="w-full max-w-full px-3 lg-max:mt-6 xl:w-1/2">
            <div
                class="relative flex flex-col h-full min-w-0 break-words bg-white border-0 shadow-soft-xl rounded-2xl bg-clip-border">
                <div class="p-4 pb-0 mb-0 bg-white border-b-0 rounded-t-2xl">
                    <div class="flex flex-wrap -mx-3">
                        <div class="flex items-center w-full max-w-full px-3 shrink-0 md:w-8/12 md:flex-none">
                            <h6 class="mb-0">Profile Information</h6>
                        </div>
                        <div id="edit_profile_btn"
                            class="w-full max-w-full px-3 text-right shrink-0 md:w-4/12 md:flex-none rounded-lg shadow-soft-lg bg-gradient-to-tl from-blue-600 to-cyan-400 text-white">
                            <a href="javascript:;" data-target="tooltip_trigger" data-placement="top">
                                <i class="leading-normal fas fa-user-edit text-sm text-white"></i>&nbsp; Edit
                                Profile
                            </a>
                            <div data-target="tooltip"
                                class="hidden px-2 py-1 text-center text-white bg-black rounded-lg text-sm"
                                role="tooltip">
                                Edit Profile
                                <div class="invisible absolute h-2 w-2 bg-inherit before:visible before:absolute before:h-2 before:w-2 before:rotate-45 before:bg-inherit before:content-['']"
                                    data-popper-arrow></div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="flex-auto p-4">
                    <!-- <div class="col-md-8 profile-text"> -->
                    <span class="msg"></span>
                    <h3>
                        <?= strtoupper($user->first_name . " " . $user->last_name) ?>

                    </h3>
                    <form id="update_profile_form" action="" method="post">
                        <table class="table table-flush text-slate-500 text-sm">
                            <tr>
                                <th>Email Address</th>
                                <td><?= $user->email ?></td>
                            </tr>
                            <tr>
                                <th>Phone Number</th>
                                <td><?= $user->phone ?>
                                </td>
                            </tr>
                            <tr>
                                <th>Address</th>
                                <td>
                                    <textarea required disabled class="form-control" name="address" id="address"
                                        rows="4"><?= $user->address ?></textarea>
                                </td>
                            </tr>
                            <tr>
                                <th>Password</th>
                                <td>
                                    <input required disabled class="form-control" type="password" name="password"
                                        id="password" value="<?= $user->password ?>">
                                </td>
                            </tr>
                            <tr>
                                <th>Confirm Password</th>
                                <td>
                                    <input required disabled class="form-control" type="password" name="confirm_pass"
                                        id="confirm_pass" value="">
                                </td>
                            </tr>
                        </table>
                        <!-- <br> -->
                        <button type="submit" style="display: none;" id="save_btn"
                            class="btn btn-theme m-2 rounded-lg text-white bg-gradient-to-tl from-green-600 to-lime-400"><i
                                class="fa fa-save"></i>
                            Update</button>

                    </form>

                </div>
            </div>
        </div>

    </div>

    <script>
    $(document).ready(function() {
        $("#edit_profile_btn").click(function() {
            $("#save_btn").css({
                "display": ""
            })

            $(this).hide()


            $("#address").prop("disabled", false)
            $("#password").prop("disabled", false)
            $("#confirm_pass").prop("disabled", false)

        })
    })
    $(document).on("submit", "#update_profile_form", function(e) {

        e.preventDefault()
        var address = $("#address").val()
        var password = $("#password").val()
        var confirm_pass = $("#confirm_pass").val()


        if (address == "") {
            iziToast.show({
                title: 'Error!',
                message: "Address Field Cannot be Empty",
                color: "yellow",
                position: "topRight",
                balloon: true
            });

            return false
        }

        if (password.length < 6) {

            iziToast.show({
                title: 'Error!',
                message: "Password length must be at least 6 characters",
                color: "yellow",
                position: "topRight",
                balloon: true
            });

            return false
        }
        if (confirm_pass != password) {

            iziToast.show({
                title: 'Error!',
                message: "Password do not match",
                color: "yellow",
                position: "topRight",
                balloon: true
            });


            return false
        }

        $.ajax({
            method: "POST",
            dataType: 'json',
            url: "includes/components/save_profile.php",
            data: $(this).serialize(),
            success: function(response) {
                // console.log(response)
                if (response.response_code == "00") {

                    iziToast.show({
                        title: 'Done!',
                        message: "Profile Updated Successfuly",
                        color: "green",
                        position: "center",
                        balloon: true
                    });


                } else {

                    iziToast.show({
                        title: 'Error!',
                        message: response.message,
                        color: "red",
                        position: "topRight",
                        balloon: true
                    });

                }
            },
            error: function(error) {
                // console.log(error)
                if (error) {
                    var res = JSON.parse(error.responseText)

                    iziToast.show({
                        title: 'Error!',
                        message: res.message,
                        color: "red",
                        position: "topRight",
                        balloon: true
                    });

                }
            }
        }).done(function() {
            $("#save_btn").css({
                "display": "none"
            })

            $("#edit_profile_btn").show()

            $("#address").prop("disabled", true)
            $("#password").prop("disabled", true)
            $("#confirm_pass").prop("disabled", true)

        })



    })
    </script>