<?php
require_once('../../vendor/autoload.php');
require_once('../init.php');

function error_res($status, $response_code, $message)
{
    $response = new stdClass;
    $response->status = $status;
    $response->response_code = $response_code;
    $response->message = $message;
    return json_encode($response);
}

if (isset($_SESSION['user_id'], $_GET['record_id'])) {

    $user = User::find_by_id($_SESSION['user_id']);
    if ($user) {
        $service_record = ServiceRecord::find_by_id($_GET['record_id']);

        if (!$service_record) {
            echo error_res(false, "03", "Sorry Record Not Found!qqqqqqq");
            exit;
        }

        $response_std = json_decode($service_record->response);
        $response_std->record_id = $service_record->id;
        $response_std->search_query = $service_record->search_query;
        echo (json_encode($response_std));
        exit;
    }
} else {
    echo error_res(false, "03", "Contact Administrator!");
    exit;
}