<?php
require_once('../../vendor/autoload.php');
require_once('../init.php');
$client = new \GuzzleHttp\Client();

define('API_BASE', 'https://api.myidentitypass.com');
// define('API_BASE', 'https://sandbox.myidentitypass.com');

function error_res($status, $response_code, $message)
{
    $response = new stdClass;
    $response->status = $status;
    $response->response_code = $response_code;
    $response->message = $message;
    return json_encode($response);
}

if (isset($_SESSION['user_id'])) {
    extract($_POST);
    if (isset($phone) && !empty($service_type)) {

        $user = User::find_by_id($_SESSION['user_id']);
        if ($user) {

            $service_type = Service::find_by_id($service_type);
            $sub_service = SubService::find_by_id($sub_service_id);


            if (!$service_type) {
                echo error_res(false, "03", "Service Not Avilable, Contact Administrator!");
                exit;
            }
            if (!$sub_service) {
                echo error_res(false, "03", "Service Not Avilable, Contact Administrator!");
            exit;
        }

            $service = $service_type->service_name;
            $service_fee = intval($service_type->service_fee);
            $status = 0;

            $my_wallet = Wallet::find_by_query("SELECT * FROM wallet WHERE user_id =" . $user->id . " LIMIT 1");
            $my_wallet = array_shift($my_wallet);
            $my_wallet_balance = intval($my_wallet->balance);

            if ($my_wallet_balance >= ($service_fee + intval($sub_service->service_fee))) {


                try {

                    $response = $client->request('POST', API_BASE . '/api/v2/biometrics/merchant/data/verification/phone_number/advance', [
                        'body' => '{"number":"' . $phone . '"}',
                        'headers' => [
                            'accept' => 'application/json',
                            'x-api-key' => x_api_key,
                            'content-type' => 'application/json',
                            'app-id' => app_id,
                        ],
                    ]);

                    $responses = $response->getBody();
                } catch (\Throwable $th) {

                    try {

                        $responses_er = explode('response:', $th->getMessage());
                        $responses = $responses_er[1];
                        $res_std = json_decode($responses);
                        $search = array("[", "]");
                        echo error_res(false, "03", str_replace($search, "", $res_std->detail->number));
                        exit;
                    } catch (\Throwable $th2) {

                        echo error_res(false, "03", "Invalid Request detail!");
                        exit;
                    }
                }



                $response_std = json_decode($responses);

                if (isset($response_std->data)) {
                    $response_std->nin_data = $response_std->data;
                    $response_std->data = null;
                    $responses = json_encode($response_std);
                }


                $service_record = new ServiceRecord;
                $in_transaction = new InTransaction;

                if ($response_std->response_code == "00") {
                    $status = 1;
                    $new_wallet_balance = $my_wallet_balance - ($service_fee + intval($sub_service->service_fee));
                    // $new_wallet_balance = $my_wallet_balance  - $service_fee;
                    $my_wallet->balance = $new_wallet_balance;
                    $my_wallet->date_updated = $date;
                    $my_wallet->save();
                } else if ($response_std->response_code == "01") {
                    $service_fee = 50;
                    $new_wallet_balance = $my_wallet_balance  - $service_fee;

                    $my_wallet->balance = $new_wallet_balance;
                    $my_wallet->date_updated = $date;
                    $my_wallet->save();
                } else {
                    $new_wallet_balance = $my_wallet->balance;
                    $service_fee = 0;
                }




                $in_transaction->user_id = $user->id;
                $in_transaction->wallet_id = $my_wallet->id;
                $in_transaction->search_query = $phone;
                $in_transaction->amount = $service_fee;
                $in_transaction->remaining_balance = $new_wallet_balance;
                $in_transaction->service = $service;
                $in_transaction->date =  $date;
                $in_transaction->status = $status;

                if ($in_transaction->save()) {

                    $service_record->user_id = $user->id;
                    $service_record->service = $service;
                    $service_record->search_query = $phone;
                    $service_record->response = $responses;
                    $service_record->in_transaction_id = $in_transaction->id;
                    if ($service_record->save()) {
                        $response_std->record_id = $service_record->id;

                        if ($response_std->response_code == "01") {
                            # code...
                            echo error_res(false, "01", "Record not found!");
                            exit;
                        } else {
                            $response_std->search_query = $phone;
                            $response_std->record_id = $service_record->id;

                            echo (json_encode($response_std));
                            exit;
                        }
                    } else {
                        echo error_res(false, "03", "Contact Administrator!");
                        exit;
                    }
                } else {
                    echo error_res(false, "03", "Contact Administrator!");
                    exit;
                }
            } else {
                echo error_res(false, "03", "Insufficient wallet balance");
                exit;
            }
        } else {

            echo error_res(false, "03", "Contact Administrator!");
            exit;
        }
    } else {

        echo error_res(false, "03", "Contact Administrator!");
        exit;
    }
} else {
    echo error_res(false, "03", "Contact Administrator!");
    exit;
}