<?php
require_once('../../vendor/autoload.php');
require_once('../init.php');
$client = new \GuzzleHttp\Client();

// define('API_BASE', 'https://api.myidentitypass.com');
// define('API_BASE', 'https://sandbox.myidentitypass.com');

function error_res($status, $response_code, $message)
{
    $response = new stdClass;
    $response->status = $status;
    $response->response_code = $response_code;
    $response->message = $message;
    return json_encode($response);
}

if (isset($_SESSION['user_id'])) {
    extract($_POST);
    if (isset($phone) && !empty($service_type)) {

        $user = User::find_by_id($_SESSION['user_id']);
        if ($user) {

            $service_type = Service::find_by_id($service_type);
            $sub_service = SubService::find_by_id($sub_service_id);


            // print_r($service_type);
            // return false;

            if (!$service_type) {
                echo error_res(false, "03", "Service Not Avilable, Contact Administrator!");
                exit;
            }
            if (!$sub_service) {
                echo error_res(false, "03", "Service Not Avilable, Contact Administrator!");
            exit;
        }

            $service = $service_type->service_name;
            $service_fee = intval($service_type->service_fee);
            $status = 0;

            $my_wallet = Wallet::find_by_query("SELECT * FROM wallet WHERE user_id =" . $user->id . " LIMIT 1");
            $my_wallet = array_shift($my_wallet);
            $my_wallet_balance = intval($my_wallet->balance);

            if ($my_wallet_balance >= ($service_fee + intval($sub_service->service_fee))) {


                try {

                    $response = $client->request('POST', 'https://api.idfinder.com.ng/merchant/nin-search/by-phone-number', [
                        'body' => '{"phoneNumber":"' . $phone . '","ninSlipFormat":"Raw-Info"}',
                        'headers' => [
                            'accept' => 'application/json',
                            'Authorization' => 'Bearer eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpc3MiOiJodHRwczovL2lkZmluZGVyLmNvbSIsImlhdCI6MTY3NTUwNzczNiwiZW1haWwiOnlhbWFsYTQ5QGdtYWlsLmNvbSwiaWQiOmI1M2JjNTI5LTAyYzUtNGQ2OS04MWRjLWMxNzVjODk1YTJhZSwicmVmZXJyZWRCeSI6MTcwLzUwLCJ1c2VyVHlwZSI6TWVyY2hhbnR9.ruWOP7YRn3G-DyAbMZnHnVmT0Sb3IXoBYVt4_ZGdrDQ',
                            'content-type' => 'application/json',
                        ],
                    ]);

                    $responses = $response->getBody();
                } catch (\Throwable $th) {

                    // print_r($th->getMessage());
                    echo error_res(false, "03", "Network Error!");
                    exit;
                }

                // print_r();

                // $responses = '{
                //     "code": 200,
                //     "data": [
                //     {
                //     "contactInfo": {
                //     "birthCountry": "",
                //     "birthLga": "",
                //     "birthState": "",
                //     "originLga": "",
                //     "originPlace": "",
                //     "originState": "",
                //     "residenceAdressLine1": "SANANNAH STREET LOW COST AREA",
                //     "residenceAdressLine2": "",
                //     "residenceLga": "Potiskum",
                //     "residencePostalcode": "",
                //     "residenceState": "Yobe",
                //     "residenceStatus": "birth",
                //     "residenceTown": "POTISKUM"
                //     },
                //     "message": "Search was successful",
                //     "nextOfKinInfo": {
                //     "addressLine1": "",
                //     "addressLine2": "",
                //     "firstName": "",
                //     "lga": "",
                //     "middleName": "",
                //     "postalCode": "",
                //     "state": "",
                //     "surName": "",
                //     "town": ""
                //     },
                //     "ninInfo": {
                //     "batchId": "",
                //     "cardStatus": "",
                //     "centralID": "",
                //     "documentNumber": "",
                //     "nin": "32064990855",
                //     "trackingId": "SCMPW0ORIL00APU",
                //     "userId": "",
                //     "vNin": ""
                //     },
                //     "personalInfo": {
                //     "dob": "11-05-1995",
                //     "educationLevel": "",
                //     "email": "",
                //     "employmentStatus": "",
                //     "firstName": "ISAH",
                //     "gender": "m",
                //     "height": "",
                //     "maidenName": "",
                //     "maritalStatus": "single",
                //     "middleName": "",
                //     "nativeLanguage": "",
                //     "otherLanguage": "",
                //     "otherName": "",
                //     "phoneNumber": "08161838283",
                //     "photo": "data:image/jpg;base64,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",
                //     "profession": "",
                //     "religion": "islam",
                //     "signature": "data:image/jpg;base64,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",
                //     "surName": "AHMED",
                //     "title": "mr"
                //     },
                //     "previousInformation": {
                //     "firstName": "",
                //     "middleName": "",
                //     "surName": ""
                //     }
                //     }
                //     ],
                //     "message": "Search by phone number response",
                //     "status": "Success"
                // }';



                $response_std = json_decode($responses);
                // print_r($response_std);



                $service_record = new ServiceRecord;
                $in_transaction = new InTransaction;




                if (isset($response_std->data) && !empty($response_std->data) && $response_std->code == 200) {
                    $status = 1;

                    $new_response_std = new stdClass;
                    $new_response_std->response_code = "00";
                    $new_response_std->detail = "Verification Successful";
                    $new_response_std->nin_data = new stdClass;


                    // $new_response_std->nin_data->birthcountry = $response_std->data[0]->contactInfo->
                    $new_response_std->nin_data->birthdate = $response_std->data->data[0]->personalInfo->dob;
                    $new_response_std->nin_data->birthlga = "";
                    $new_response_std->nin_data->birthstate = "";
                    $new_response_std->nin_data->centralID = "";
                    $new_response_std->nin_data->educationallevel = $response_std->data->data[0]->personalInfo->educationLevel;
                    $new_response_std->nin_data->email = $response_std->data->data[0]->personalInfo->email;
                    $new_response_std->nin_data->emplymentstatus = "";
                    $new_response_std->nin_data->firstname = $response_std->data->data[0]->personalInfo->firstName;
                    $new_response_std->nin_data->middlename = $response_std->data->data[0]->personalInfo->middleName;
                    $new_response_std->nin_data->gender = $response_std->data->data[0]->personalInfo->gender;
                    $new_response_std->nin_data->heigth = "";
                    $new_response_std->nin_data->maritalstatus = $response_std->data->data[0]->personalInfo->maritalStatus;
                    $new_response_std->nin_data->nin = $response_std->data->data[0]->ninInfo->nin;
                    $new_response_std->nin_data->trackingId = $response_std->data->data[0]->ninInfo->trackingId;
                    $new_response_std->nin_data->nok_address1 = "";
                    $new_response_std->nin_data->nok_address2 = "";
                    $new_response_std->nin_data->nok_firstname = "";
                    $new_response_std->nin_data->nok_lga = "";
                    $new_response_std->nin_data->nok_middlename = "";
                    $new_response_std->nin_data->nok_postalcode = "";
                    $new_response_std->nin_data->nok_state = "";
                    $new_response_std->nin_data->nok_surname = "";
                    $new_response_std->nin_data->nok_town = "";
                    $new_response_std->nin_data->nspokenlang = "";
                    $new_response_std->nin_data->ospokenlang = "";
                    $new_response_std->nin_data->pfirstname = "";
                    $new_response_std->nin_data->photo = explode(",", $response_std->data->data[0]->personalInfo->photo)[1];
                    $new_response_std->nin_data->pmiddlename = "";
                    $new_response_std->nin_data->profession = "";
                    $new_response_std->nin_data->psurname = "";
                    $new_response_std->nin_data->religion = $response_std->data->data[0]->personalInfo->religion;
                    $new_response_std->nin_data->residence_address = $response_std->data->data[0]->contactInfo->residenceAdressLine1;
                    $new_response_std->nin_data->residence_town = $response_std->data->data[0]->contactInfo->residenceTown;
                    $new_response_std->nin_data->residence_lga = $response_std->data->data[0]->contactInfo->residenceLga;
                    $new_response_std->nin_data->residence_state = $response_std->data->data[0]->contactInfo->residenceState;
                    $new_response_std->nin_data->residencestatus = $response_std->data->data[0]->contactInfo->residenceStatus;
                    $new_response_std->nin_data->self_origin_lga = "";
                    $new_response_std->nin_data->self_origin_place = "";
                    $new_response_std->nin_data->self_origin_state = "";
                    $new_response_std->nin_data->signature = explode(",", $response_std->data->data[0]->personalInfo->signature)[1];
                    $new_response_std->nin_data->surname = $response_std->data->data[0]->personalInfo->surName;
                    $new_response_std->nin_data->telephoneno = $response_std->data->data[0]->personalInfo->phoneNumber;
                    $new_response_std->nin_data->title = "";
                    $new_response_std->nin_data->vnin = "";
                    $new_response_std->nin_data->userid = "";

                    $new_response_std->verification = new stdClass;
                    $new_response_std->verification->status = '';
                    $new_response_std->verification->reference = "";



                    // print_r($new_response_std);
                    // return false;

                    // $new_wallet_balance = $my_wallet_balance  - $service_fee;
                    $new_wallet_balance = $my_wallet_balance - ($service_fee + intval($sub_service->service_fee));

                    $my_wallet->balance = $new_wallet_balance;
                    $my_wallet->date_updated = $date;
                    $my_wallet->save();
                } else if (isset($response_std->data) && empty($response_std->data) && $response_std->code == 200) {

                    echo error_res(false, "01", $response_std->message);
                    $in_transaction->user_id = $user->id;
                    $in_transaction->wallet_id = $my_wallet->id;
                    $in_transaction->search_query = $nin;
                    $in_transaction->amount = 0;
                    $in_transaction->remaining_balance = $my_wallet->balance;
                    // $in_transaction->service = $service;
                    $in_transaction->service = $service_type->service_name;
                    $in_transaction->date =  $date;
                    $in_transaction->status = $status;
                    $in_transaction->save();
                    exit;
                } else if ($response_std->code == 422) {
                    echo error_res(false, "01", $response_std->errors->phoneNumber[0]);
                    $in_transaction->user_id = $user->id;
                    $in_transaction->wallet_id = $my_wallet->id;
                    $in_transaction->search_query = $nin;
                    $in_transaction->amount = 0;
                    $in_transaction->remaining_balance = $my_wallet->balance;
                    // $in_transaction->service = $service;
                    $in_transaction->service = $service_type->service_name;
                    $in_transaction->date =  $date;
                    $in_transaction->status = $status;
                    $in_transaction->save();
                    exit;



                    // $new_wallet_balance = $my_wallet_balance  - 49;
                    // $my_wallet->balance = $new_wallet_balance;
                    // $my_wallet->date_updated = $date;
                    // $my_wallet->save();
                } else {
                    $new_wallet_balance = $my_wallet->balance;
                    $service_fee = 0;
                }




                $in_transaction->user_id = $user->id;
                $in_transaction->wallet_id = $my_wallet->id;
                $in_transaction->search_query = $phone;
                $in_transaction->amount = $service_fee;
                $in_transaction->remaining_balance = $new_wallet_balance;
                // $in_transaction->service = $service;
                $in_transaction->service = $service_type->service_name;
                $in_transaction->date =  $date;
                $in_transaction->status = $status;

                if ($in_transaction->save()) {

                    $service_record->user_id = $user->id;
                    // $service_record->service = $service;
                    $service_record->service = $service_type->service_name;
                    $service_record->search_query = $phone;
                    $service_record->response = json_encode($new_response_std);
                    $service_record->in_transaction_id = $in_transaction->id;
                    if ($service_record->save()) {
                        $new_response_std->record_id = $service_record->id;

                        $new_response_std->search_query = $phone;
                        // $new_response_std->record_id = $service_record->id;

                        echo (json_encode($new_response_std));
                        exit;
                    } else {
                        echo error_res(false, "03", "Contact Administrator!");
                        exit;
                    }
                } else {
                    echo error_res(false, "03", "Contact Administrator!");
                    exit;
                }
            } else {
                echo error_res(false, "03", "Insufficient wallet balance");
                exit;
            }
        } else {

            echo error_res(false, "03", "Contact Administrator!");
            exit;
        }
    } else {

        echo error_res(false, "03", "Contact Administrator!");
        exit;
    }
} else {
    echo error_res(false, "03", "Contact Administrator!");
    exit;
}