<?php
require_once('../../vendor/autoload.php');
require_once('../init.php');
$client = new \GuzzleHttp\Client();

// define('API_BASE', 'https://api.myidentitypass.com');
// define('API_BASE', 'https://sandbox.myidentitypass.com');

function error_res($status, $response_code, $message)
{
    $response = new stdClass;
    $response->status = $status;
    $response->response_code = $response_code;
    $response->message = $message;
    return json_encode($response);
}

if (isset($_SESSION['user_id'])) {
    extract($_POST);

    // print_r($_POST);
    // print_r($_FILES);
    // return false;
    if (isset($_POST)) {

        $user = User::find_by_id($_SESSION['user_id']);
        if ($user) {

            $service_type = Service::find_by_id($service_type);
            $sub_service = SubService::find_by_id($sub_service_id);

            // print_r($sub_service);

            // return false;


            if (!$service_type) {
                echo error_res(false, "03", "Service Not Avilable, Contact Administrator!");
                exit;
            }
            if (!$sub_service) {
                echo error_res(false, "03", "Service Not Avilable, Contact Administrator!");
                exit;
            }

            $service = $service_type->service_name;
            $service_fee = intval($service_type->service_fee);
            $status = 0;

            $my_wallet = Wallet::find_by_query("SELECT * FROM wallet WHERE user_id =" . $user->id . " LIMIT 1");
            $my_wallet = array_shift($my_wallet);
            $my_wallet_balance = intval($my_wallet->balance);

            if ($my_wallet_balance >= ($service_fee + intval($sub_service->service_fee))) {
                
                try {
                
                    $jamb = new Jamb;
                    $jamb->user_id = $user->id;
                    $jamb->service_id = $service_type->id;
                    $jamb->submitted_date = $date;
                    $jamb->sub_service = SubService::find_by_id($sub_service_id)->service_name;
                    foreach ($_POST as $key => $value) {
                        $jamb->{$key} = $value;

                    }
                    // $jamb->fullname = $fullname;
                    // $jamb->type = $type;
                    // $jamb->profile_code = $profile_code;
                    // $jamb->jamb_year = $jamb_year;

                    foreach ($_FILES as $key => $file) {
                        $doc_type = explode('/', $_FILES[$key]['type']);
                        $new_name = explode("/",$profile_code)[0];
                        $jamb->{$key} = $key . "_" . $user->id . "_" . $new_name . "." . $doc_type[1];
                        $doc = $_FILES[$key]['tmp_name'];
                        move_uploaded_file($doc, "../../jamb_docs/" . $jamb->{$key});

                    }



                    // print_r($jamb);
                    // return $jamb;




                } catch (\Throwable $th) {

                    echo error_res(false, "04", "Something went wrong!.");
                    exit;
                }

                if ($jamb->save()) {
                    $status = 1;

                    $new_response_std = new stdClass;
                    $new_response_std->response_code = "00";
                    $new_response_std->detail = "Submitted Successful";
                    $new_response_std->data = new stdClass;

                    $new_response_std->data = $jamb;

                    $new_response_std->status = 'success';
                    $new_response_std->reference = "";

                    $fee = $service_fee + intval($sub_service->service_fee);

                    // print_r($fee);
                    // return false;
                    $new_wallet_balance = $my_wallet_balance - $fee;
                    $my_wallet->balance = $new_wallet_balance;
                    $my_wallet->date_updated = $date;
                    $my_wallet->save();
                } else {
                    $new_wallet_balance = $my_wallet->balance;
                    $service_fee = 0;
                }

                // $new_response_std->record_id = $service_record->id;

                $new_response_std->search_query = $profile_code;
                // $new_response_std->record_id = $service_record->id;

                echo (json_encode($new_response_std));
                exit;


            } else {
                echo error_res(false, "03", "Insufficient wallet balance");
                exit;
            }
        } else {

            echo error_res(false, "03", "Contact Administrator!");
            exit;
        }
    } else {

        echo error_res(false, "03", "Contact Administrator!");
        exit;
    }
} else {
    echo error_res(false, "03", "Contact Administrator!");
    exit;
}