<?php
require_once('../../vendor/autoload.php');
require_once('../init.php');
$client = new \GuzzleHttp\Client();

define('API_BASE', 'https://api.myidentitypass.com');
// define('API_BASE', 'https://sandbox.myidentitypass.com');

function error_res($status, $response_code, $message)
{
    $response = new stdClass;
    $response->status = $status;
    $response->response_code = $response_code;
    $response->message = $message;
    return json_encode($response);
}

if (isset($_SESSION['user_id'])) {
    extract($_POST);
    if (isset($bvn) && !empty($bvn) && !empty($service_type)) {

        $user = User::find_by_id($_SESSION['user_id']);
        if ($user) {

            $service_type = Service::find_by_id($service_type);
            $sub_service = SubService::find_by_id($sub_service_id);

            if (!$service_type) {
                echo error_res(false, "03", "Service Not Avilable, Contact Administrator!");
                exit;
            }
            if (!$sub_service) {
                echo error_res(false, "03", "Service Not Avilable, Contact Administrator!");
            exit;
            }
        

            $service = $service_type->service_name;
            $service_fee = intval($service_type->service_fee);
            $status = 0;

            $my_wallet = Wallet::find_by_query("SELECT * FROM wallet WHERE user_id =" . $user->id . " LIMIT 1");
            $my_wallet = array_shift($my_wallet);
            $my_wallet_balance = intval($my_wallet->balance);

            if ($my_wallet_balance >= ($service_fee + intval($sub_service->service_fee))) {

                try {

                    $response = $client->request('POST', 'https://api.prembly.com/identitypass/verification/bvn', [
                        'body' => '{"number":"' . $bvn . '"}',
                        'headers' => [
                            'accept' => 'application/json',
                             // 'x-api-key' => 'live_sk_YmvFR1W37jxaaygVFYmiATnzqTPRYcPgOS8sxOx',
                            'x-api-key' => 'live_sk_22889c9b77602da66bd6501a61196a410378e0d',
                            'content-type' => 'application/json',
                            // 'app-id' => 'e183e0bc-d262-4c90-8a75-caa3ff4a87d8',
                            'app-id' => '386dc4bd-0c6e-44a6-b174-7aea2b14ef45',
                        ],
                    ]);

                    $responses = $response->getBody();
                } catch (\Throwable $th) {
                    // print_r($th->getMessage());
                    echo error_res(false, "03", "Server Error Contact Administrator!");
                    exit;
                }



                $response_std = json_decode($responses);

                // print_r($response_std);
                // exit;

                $service_record = new ServiceRecord;
                $in_transaction = new InTransaction;

                if ($response_std->response_code == "00") {
                    $status = 1;
                    // $new_wallet_balance = $my_wallet_balance  - $service_fee;
                    $new_wallet_balance = $my_wallet_balance - ($service_fee + intval($sub_service->service_fee));

                    $my_wallet->balance = $new_wallet_balance;
                    $my_wallet->date_updated = $date;
                    $my_wallet->save();
                } else {
                    $new_wallet_balance = $my_wallet->balance;
                    $service_fee = 0;
                }



                $in_transaction->user_id = $user->id;
                $in_transaction->wallet_id = $my_wallet->id;
                $in_transaction->search_query = $bvn;
                $in_transaction->amount = $service_fee;
                // $in_transaction->service_id = intval($service_type);
                $in_transaction->remaining_balance = $new_wallet_balance;
                $in_transaction->service = $service;
                $in_transaction->date =  $date;
                $in_transaction->status = $status;

                if ($in_transaction->save()) {

                    $service_record->user_id = $user->id;
                    $service_record->service = $service;
                    $service_record->search_query = $bvn;
                    $service_record->response = $responses;
                    $service_record->in_transaction_id = $in_transaction->id;
                    if ($service_record->save()) {
                        $response_std->record_id = $service_record->id;
                        $response_std->search_query = $bvn;

                        echo (json_encode($response_std));
                        exit;
                    } else {
                        echo error_res(false, "03", "Contact Administrator!");
                        exit;
                    }
                } else {
                    echo error_res(false, "03", "Contact Administrator!");
                    exit;
                }
            } else {
                echo error_res(false, "03", "Insufficient wallet balance");
                exit;
            }
        } else {

            echo error_res(false, "03", "Contact Administrator!");
            exit;
        }
    } else {

        echo error_res(false, "03", "Contact Administrator!");
        exit;
    }
} else {
    echo error_res(false, "03", "Contact Administrator!");
    exit;
}