<?php
require_once('../../vendor/autoload.php');
require_once('../init.php');
$client = new \GuzzleHttp\Client();

// define('API_BASE', 'https://api.myidentitypass.com');
// define('API_BASE', 'https://sandbox.myidentitypass.com');

function error_res($status, $response_code, $message)
{
    $response = new stdClass;
    $response->status = $status;
    $response->response_code = $response_code;
    $response->message = $message;
    return json_encode($response);
}

if (isset($_SESSION['user_id'])) {
    extract($_POST);
    if (isset($nin) && !empty($service_type)) {

        $user = User::find_by_id($_SESSION['user_id']);
        if ($user) {

            $service_type = Service::find_by_id($service_type);
            $sub_service = SubService::find_by_id($sub_service_id);


            // print_r($service_type);
            // return false;

            if (!$service_type) {
                echo error_res(false, "03", "Service Not Avilable, Contact Administrator!");
                exit;
            }

            if (!$sub_service) {
                echo error_res(false, "03", "Service Not Avilable, Contact Administrator!");
            exit;
        }

            $service = $service_type->service_name;
            $service_fee = intval($service_type->service_fee);
            $status = 0;

            $my_wallet = Wallet::find_by_query("SELECT * FROM wallet WHERE user_id =" . $user->id . " LIMIT 1");
            $my_wallet = array_shift($my_wallet);
            $my_wallet_balance = intval($my_wallet->balance);

            if ($my_wallet_balance >= ($service_fee + intval($sub_service->service_fee))) {


                try {

                    $response = $client->request('POST', 'https://flenxo.com/api/verification/nin', [
                        'form_params' => [
                            'number' => $nin,
                        ],
                        'headers' => [
                            'Authorization' => 'Bearer live_skB24b463mep8AbrhnSf080a9ci4aSbcN151Zfbff2',
                        ],
                    ]);

                    $responses = $response->getBody();
                } catch (\Throwable $th) {

                    // print_r($th->getMessage());
                    echo error_res(false, "03", "Record not found!");
                    $new_wallet_balance = $my_wallet_balance  - 0;
                    $my_wallet->balance = $new_wallet_balance;
                    $my_wallet->date_updated = $date;
                    $my_wallet->save();
                    exit;
                }



                $response_std = json_decode($responses);
                // print_r($response_std);

                // return false;



                $service_record = new ServiceRecord;
                $in_transaction = new InTransaction;




                if (isset($response_std->data) && !empty($response_std->data) && $response_std->code == 200) {
                    $status = 1;

                    $new_response_std = new stdClass;
                    $new_response_std->response_code = "00";
                    $new_response_std->detail = "Verification Successful";
                    $new_response_std->nin_data = new stdClass;


                    // $new_response_std->nin_data->birthcountry = $response_std->contactInfo->
                    $new_response_std->nin_data->birthdate = $response_std->data->personalInfo->dob;
                    $new_response_std->nin_data->birthlga = "";
                    $new_response_std->nin_data->birthstate = "";
                    $new_response_std->nin_data->centralID = "";
                    $new_response_std->nin_data->educationallevel = $response_std->data->personalInfo->educationLevel;
                    $new_response_std->nin_data->email = $response_std->data->personalInfo->email;
                    $new_response_std->nin_data->emplymentstatus = "";
                    $new_response_std->nin_data->firstname = $response_std->data->personalInfo->firstName;
                    $new_response_std->nin_data->middlename = $response_std->data->personalInfo->middleName;
                    $new_response_std->nin_data->gender = $response_std->data->personalInfo->gender;
                    $new_response_std->nin_data->heigth = "";
                    $new_response_std->nin_data->maritalstatus = $response_std->data->personalInfo->maritalStatus;
                    $new_response_std->nin_data->nin = $response_std->data->ninInfo->nin;
                    $new_response_std->nin_data->trackingId = $response_std->data->ninInfo->trackingId;
                    $new_response_std->nin_data->nok_address1 = "";
                    $new_response_std->nin_data->nok_address2 = "";
                    $new_response_std->nin_data->nok_firstname = "";
                    $new_response_std->nin_data->nok_lga = "";
                    $new_response_std->nin_data->nok_middlename = "";
                    $new_response_std->nin_data->nok_postalcode = "";
                    $new_response_std->nin_data->nok_state = "";
                    $new_response_std->nin_data->nok_surname = "";
                    $new_response_std->nin_data->nok_town = "";
                    $new_response_std->nin_data->nspokenlang = "";
                    $new_response_std->nin_data->ospokenlang = "";
                    $new_response_std->nin_data->pfirstname = "";
                    $new_response_std->nin_data->photo = $response_std->data->personalInfo->photo;
                    $new_response_std->nin_data->pmiddlename = "";
                    $new_response_std->nin_data->profession = "";
                    $new_response_std->nin_data->psurname = "";
                    $new_response_std->nin_data->religion = $response_std->data->personalInfo->religion;
                    $new_response_std->nin_data->residence_address = $response_std->data->contactInfo->residenceAdressLine1;
                    $new_response_std->nin_data->residence_town = $response_std->data->contactInfo->residenceTown;
                    $new_response_std->nin_data->residence_lga = $response_std->data->contactInfo->residenceLga;
                    $new_response_std->nin_data->residence_state = $response_std->data->contactInfo->residenceState;
                    $new_response_std->nin_data->residencestatus = $response_std->data->contactInfo->residenceStatus;
                    $new_response_std->nin_data->self_origin_lga = "";
                    $new_response_std->nin_data->self_origin_place = "";
                    $new_response_std->nin_data->self_origin_state = "";
                    $new_response_std->nin_data->signature = $response_std->data->personalInfo->signature;
                    $new_response_std->nin_data->surname = $response_std->data->personalInfo->surName;
                    $new_response_std->nin_data->telephoneno = $response_std->data->personalInfo->phoneNumber;
                    $new_response_std->nin_data->title = "";
                    $new_response_std->nin_data->vnin = "";
                    $new_response_std->nin_data->userid = "";

                    $new_response_std->verification = new stdClass;
                    $new_response_std->verification->status = '';
                    $new_response_std->verification->reference = "";



                    // print_r($new_response_std);
                    // return false;

                    // $new_wallet_balance = $my_wallet_balance  - $service_fee;
                    $new_wallet_balance = $my_wallet_balance - ($service_fee + intval($sub_service->service_fee));

                    $my_wallet->balance = $new_wallet_balance;
                    $my_wallet->date_updated = $date;
                    $my_wallet->save();
                } else if (isset($response_std->data) && empty($response_std->data) && $response_std->code == 200) {

                    echo error_res(false, "01", $response_std->message);
                    $in_transaction->user_id = $user->id;
                    $in_transaction->wallet_id = $my_wallet->id;
                    $in_transaction->search_query = $nin;
                    $in_transaction->amount = 0;
                    $in_transaction->remaining_balance = $my_wallet->balance;
                    // $in_transaction->service = $service;
                    $in_transaction->service = $service_type->service_name;
                    $in_transaction->date =  $date;
                    $in_transaction->status = $status;
                    $in_transaction->save();
                    exit;
                } else if ($response_std->code == 422) {
                    echo error_res(false, "01", $response_std->errors->phoneNumber[0]);
                    $in_transaction->user_id = $user->id;
                    $in_transaction->wallet_id = $my_wallet->id;
                    $in_transaction->search_query = $nin;
                    $in_transaction->amount = 0;
                    $in_transaction->remaining_balance = $my_wallet->balance;
                    // $in_transaction->service = $service;
                    $in_transaction->service = $service_type->service_name;
                    $in_transaction->date =  $date;
                    $in_transaction->status = $status;
                    $in_transaction->save();
                    exit;



                    // $new_wallet_balance = $my_wallet_balance  - 49;
                    // $my_wallet->balance = $new_wallet_balance;
                    // $my_wallet->date_updated = $date;
                    // $my_wallet->save();
                } else {
                    $new_wallet_balance = $my_wallet->balance;
                    $service_fee = 0;
                }




                $in_transaction->user_id = $user->id;
                $in_transaction->wallet_id = $my_wallet->id;
                $in_transaction->search_query = $nin;
                $in_transaction->amount = $service_fee;
                $in_transaction->remaining_balance = $new_wallet_balance;
                // $in_transaction->service = $service;
                $in_transaction->service = $service_type->service_name;
                $in_transaction->date =  $date;
                $in_transaction->status = $status;

                if ($in_transaction->save()) {

                    $service_record->user_id = $user->id;
                    // $service_record->service = $service;
                    $service_record->service = $service_type->service_name;
                    $service_record->search_query = $nin;
                    $service_record->response = json_encode($new_response_std);
                    $service_record->in_transaction_id = $in_transaction->id;
                    if ($service_record->save()) {
                        $new_response_std->record_id = $service_record->id;

                        $new_response_std->search_query = $nin;
                        // $new_response_std->record_id = $service_record->id;

                        echo (json_encode($new_response_std));
                        exit;
                    } else {
                        echo error_res(false, "03", "Contact Administrator!");
                        exit;
                    }
                } else {
                    echo error_res(false, "03", "Contact Administrator!");
                    exit;
                }
            } else {
                echo error_res(false, "03", "Insufficient wallet balance");
                exit;
            }
        } else {

            echo error_res(false, "03", "Contact Administrator!");
            exit;
        }
    } else {

        echo error_res(false, "03", "Contact Administrator!");
        exit;
    }
} else {
    echo error_res(false, "03", "Contact Administrator!");
    exit;
}