<?php

ini_set('memory_limit', -1);
require_once("../main_includes/init.php");
if (!isset($_GET['record'], $_SESSION['user_id'])) {
    redirect("../");
}
require('fpdf/fpdf.php');
// include('../includes/configpdo.php');

$user = User::find_by_id($_SESSION['user_id']);
if (!$user) {
    redirect("../");
}

$sub_service = SubService::find_by_id($_GET['service_id']);
if (!$sub_service) {
    redirect("../");
}

$service_fee = intval($sub_service->service_fee);
$status = 1;
$service = $sub_service->service_name;

$my_wallet = Wallet::find_by_query("SELECT * FROM wallet WHERE user_id =" . $user->id . " LIMIT 1");
$my_wallet = array_shift($my_wallet);
$my_wallet_balance = intval($my_wallet->balance);

// if ($my_wallet_balance < $service_fee) {
//     redirect("../");
//     return false;
// }

$service_record = ServiceRecord::find_by_id($_GET['record']);
if (!$service_record) {
    redirect("../");
    return false;
}

$response_std = json_decode($service_record->response);
// echo "<pre>";
// print_r($response_std);
$bvn = $response_std->data->bvn;
$nin = $response_std->data->nin;


// $new_wallet_balance = $my_wallet_balance  - $service_fee;
// $my_wallet->balance = $new_wallet_balance;
// $my_wallet->date_updated = $date;
// $my_wallet->save();

$in_transaction = new InTransaction;
$in_transaction->user_id = $user->id;
$in_transaction->wallet_id = $my_wallet->id;
$in_transaction->amount = $service_fee;
$in_transaction->remaining_balance = $my_wallet_balance;
$in_transaction->service = $service;
$in_transaction->date = $status == 1 ? $date : $in_transaction->date;
$in_transaction->service_id = intval($sub_service->service_id);
$in_transaction->status = $status;
$in_transaction->record_id = $service_record->id;
$in_transaction->search_query = $service_record->search_query;
if (!isset($_GET['redownload'])) {
$in_transaction->save();
}

class PDF extends FPDF
{

    function Header()
    {
        // Select Arial bold 15
        $this->SetFont('Arial', 'B', 10);
        $this->SetTextColor(0);
        $this->SetDrawColor(0, 0, 0);
        $this->Ln(20);
        $this->Cell(40, 15, '', 1, 0, 'C');
        $this->Cell(0, 15, 'The Bank Verification Number  has successfuly been verified.', 1, 1, 'C');

        $this->SetTextColor(50, 50, 50);

        $this->Image('bvn.png', 10, 30, 40, 15);
        // Line break 
        $this->Ln(2);
    }
    function Footer()
    {
        // Go to 0.10 cm from bottom
        // $this->SetY(-9);
        // $this->SetFont('Arial', 'I', 6);
        // Print centered page number
        // $this->Cell(0, 10, 'Page ' . $this->PageNo(), 0, 0, 'C');
    }
}



$filename = './tmp/t' . rand(00000000, 99999999) . '.jpeg';
if (file_exists($filename)) {
    unlink($filename);
}
$img_o = base64_decode($response_std->data->base64Image);
$img =  imagecreatefromstring($img_o);
imagejpeg($img, $filename);


$pdf = new PDF();


$pdf->AliasNbPages();
$pdf->AddPage('P', 'A4');
$pdf->SetFont('', '', 11);
$pdf->SetFillColor(255, 255, 255);

$pdf->Image($filename, 10, 59, 70);

$pdf->Ln(6);
$pdf->Cell(75, 6, '', 0, 0, 'L', false);
$pdf->SetFont('', '', 10);
$pdf->Cell(65, 6, "Date:", 0, 0, 'R', false);
$pdf->SetFont('', '', 10);
$pdf->Cell(0, 6, $date, 0, 1, 'L', false);

$pdf->SetDrawColor(150, 150, 150);
$pdf->SetFont('', 'B', 10);

$pdf->SetTextColor(120, 120, 120);
$pdf->Cell(75, 9, '', 0, 0, 'L', false);
$pdf->Cell(0, 9, 'Personal Information', 1, 1, 'C', false);

$pdf->SetFont('', '', 10);

$pdf->SetTextColor(0, 0, 0);

$pdf->Cell(75, 6, '', 0, 0, 'L', false);
$pdf->SetFont('', 'B', 10);
$pdf->Cell(35, 6, "BVN", "B R L", 0, 'L', false);
$pdf->SetFont('', '', 10);
$pdf->Cell(0, 6, $bvn, "B R", 1, 'L', false);

$pdf->Cell(75, 6, '', 0, 0, 'L', false);
$pdf->SetFont('', 'B', 10);
$pdf->Cell(35, 6, "NIN", "B R L", 0, 'L', false);
$pdf->SetFont('', '', 10);
$pdf->Cell(0, 6, $nin, "B R", 1, 'L', false);

$pdf->Cell(75, 6, '', 0, 0, 'L', false);
$pdf->SetFont('', 'B', 10);
$pdf->Cell(35, 6, "First Name", "B R L", 0, 'L', false);
$pdf->SetFont('', '', 10);
$pdf->Cell(0, 6, $response_std->data->firstName, "B R", 1, 'L', false);

$pdf->Cell(75, 6, '', 0, 0, 'L', false);
$pdf->SetFont('', 'B', 10);
$pdf->Cell(35, 6, "Last Name", "B R L", 0, 'L', false);
$pdf->SetFont('', '', 10);
$pdf->Cell(0, 6, $response_std->data->lastName, "B R", 1, 'L', false);

$pdf->Cell(75, 6, '', 0, 0, 'L', false);
$pdf->SetFont('', 'B', 10);
$pdf->Cell(35, 6, "Middle Name", "B R L", 0, 'L', false);
$pdf->SetFont('', '', 10);
$pdf->Cell(0, 6, $response_std->data->middleName, "B R", 1, 'L', false);

$pdf->Cell(75, 6, '', 0, 0, 'L', false);
$pdf->SetFont('', 'B', 10);
$pdf->Cell(35, 6, "Phone", "B R L", 0, 'L', false);
$pdf->SetFont('', '', 10);
$pdf->Cell(0, 6, $response_std->data->phoneNumber1, "B R", 1, 'L', false);

$pdf->Cell(75, 6, '', 0, 0, 'L', false);
$pdf->SetFont('', 'B', 10);
$pdf->Cell(35, 6, "Email", "B R L", 0, 'L', false);
$pdf->SetFont('', '', 10);
$pdf->Cell(0, 6, $response_std->data->email, "B R", 1, 'L', false);



$pdf->Cell(75, 6, '', 0, 0, 'L', false);
$pdf->SetFont('', 'B', 10);
$pdf->Cell(35, 6, "Date of birth", "B R L", 0, 'L', false);
$pdf->SetFont('', '', 10);
$pdf->Cell(0, 6, $response_std->data->dateOfBirth, "B R", 1, 'L', false);

$pdf->Cell(75, 6, '', 0, 0, 'L', false);
$pdf->SetFont('', 'B', 10);
$pdf->Cell(35, 6, "Gender", "B R L", 0, 'L', false);
$pdf->SetFont('', '', 10);
$pdf->Cell(0, 6, strtoupper($response_std->data->gender), "B R", 1, 'L', false);

$pdf->Cell(75, 6, '', 0, 0, 'L', false);
$pdf->SetFont('', 'B', 10);
$pdf->Cell(35, 6, "Enrollment Bank", "B R L", 0, 'L', false);
$pdf->SetFont('', '', 10);
$pdf->Cell(0, 6, $response_std->data->enrollmentBank, "B R", 1, 'L', false);

$pdf->Cell(75, 6, '', 0, 0, 'L', false);
$pdf->SetFont('', 'B', 10);
$pdf->Cell(35, 6, "Enrollment Branch", "B R L", 0, 'L', false);
$pdf->SetFont('', '', 10);
$pdf->Cell(0, 6, $response_std->data->enrollmentBranch, "B R", 1, 'L', false);

$pdf->Cell(75, 6, '', 0, 0, 'L', false);
$pdf->SetFont('', 'B', 10);
$pdf->Cell(35, 6, "Registration Date", "B R L", 0, 'L', false);
$pdf->SetFont('', '', 10);
$pdf->Cell(0, 6, $response_std->data->registrationDate, "B R", 1, 'L', false);

$pdf->Cell(75, 12, '', 0, 0, 'L', false);
$pdf->SetFont('', 'B', 10);
$pdf->Cell(35, 12, "Address", "B R L", 0, 'L', false);
$pdf->SetFont('', '', 10);
$pdf->MultiCell(0, 6, $response_std->data->residentialAddress . ",\n" . $response_std->data->stateOfResidence, "B T R", 1, 'L', false);


$pdf->Ln(5);
$pdf->MultiCell(0, 5, 'NOTE: ..', 0, 1, 'C', true);
// if ($response_std->data->photo != '') {
    if (file_exists($filename)) {
        unlink($filename);
    }
// }

$doc_name = $bvn . "_personal_info_slip.pdf";
// header_remove();
// header('Content-Type: application/pdf'); // Set the Content-Type header to indicate a PDF
// header('Content-Disposition: attachment; filename="example.pdf"');
// $pdf->Output();
$pdf->Output("D", $doc_name);
