<?php include "main_includes/header.php"; ?>

<body  style="background-image: url(assets/img/confirmid_bg.jpg); background-repeat: no-repeat;background-size: cover; background-position: center; background-attachment: fixed;" class="h-screen">


    <section class="">
        <div class="flex flex-col items-center justify-center px-6 py-8 mx-auto md:h-screen lg:py-0">
            <a href="#" class="flex items-center mb-6 text-2xl font-semibold text-teal-900 text-white">
                <div class="rounded w-20 h-20">
                    <img src="assets/img/favicon.png">
                </div>
            </a>
            <div class="w-full rounded-lg shadow border md:mt-0 sm:max-w-md xl:p-0 bg-emerald-800 border-emerald-700">
                <div class="p-6 space-y-4 md:space-y-6 sm:p-8">
                    <h1 class="text-xl font-bold leading-tight tracking-tight text-teal-900 md:text-2xl text-white">
                        Sign in to your account
                    </h1>

                    <form class="space-y-4 md:space-y-6" id="login_form" method="POST" role="form">
                        <div>
                            <label for="email" class="block mb-2 text-sm font-medium text-teal-900 text-white">Your
                                email</label>
                            <input type="email" name="email" id="email"
                                class="bg-teal-50 border py-2 border-teal-300 text-teal-900 sm:text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 bg-white border-teal-600 placeholder-gray-400 focus:ring-blue-500 focus:border-blue-500"
                                placeholder="your@email.com" required="">
                        </div>
                        <div>
                            <label for="password"
                                class="block mb-2 text-sm font-medium text-teal-900 text-white">Password</label>
                            <input type="password" name="password" id="password" placeholder="••••••••"
                                class="bg-teal-50 py-2 border border-teal-300 text-teal-900 sm:text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 bg-white border-teal-600 placeholder-gray-400 focus:ring-blue-500 focus:border-blue-500"
                                required="">
                        </div>
                        <div class="flex items-center justify-between">
                            <div class="flex items-start">
                                <div class="flex items-center h-5">
                                    <input id="remember" aria-describedby="remember" type="checkbox"
                                        class="w-4 h-4 border border-teal-300 rounded bg-teal-50 focus:ring-3 focus:ring-primary-300 bg-teal-700 border-teal-600 focus:ring-primary-600 ring-offset-teal-800">
                                </div>
                                <div class="ml-3 text-sm">
                                    <label for="remember" class="text-teal-500 text-teal-300">Remember me</label>
                                </div>
                            </div>
                            <a href="forgot_password" class="text-sm text-white font-bold hover:underline">Forgot
                                password?</a>
                        </div>
                        <button type="submit"
                            class="w-full text-white bg-primary-600 hover:bg-primary-700 focus:ring-4 focus:outline-none focus:ring-primary-300 font-medium bg-slate-900 hover:bg-slate-950 rounded-lg text-sm px-5 py-2.5 text-center bg-primary-600 hover:bg-primary-700 focus:ring-primary-800 ">Sign
                            in</button>

                        <p class="text-sm font-light text-teal-500 text-teal-400">
                            Don’t have an account yet? <a href="sign-up"
                                class="text-white font-bold hover:underline">Sign up</a>
                        </p>
                    </form>
                </div>
            </div>
        </div>
    </section>


</body>

<?php
include "./main_includes/loader_out.php";
?>
<!-- plugin for scrollbar  -->
<!-- <script src="assets/js/plugins/perfect-scrollbar.min.js" async></script> -->
<!-- main script file  -->
<!-- <script src="assets/js/soft-ui-dashboard-tailwind.js?v=1.0.4" async></script> -->
<script src="./assets/iziToast-master/dist/js/iziToast.js"></script>

<script>
    $(document).ready(function () {
        $('.lds-ellipsis').fadeOut('slow')
        $('#login').prop('disabled', false)
    })
    $(document).on("submit", "#login_form", function (e) {
        e.preventDefault()
        // console.log('ajajajaj')
        $('.msg').fadeOut('slow')
        $('.lds-ellipsis').fadeIn('slow')
        $('#login').prop('disabled', true)

        var email = $("#email").val()
        var password = $("#password").val()


        $.ajax({
            method: "POST",
            dataType: 'json',
            url: "main_includes/components/login.php",
            data: $(this).serialize(),
            success: function (response) {
                console.log(response)
                if (response.response_code == "00") {

                    $('#login').prop('disabled', false)
                    iziToast.show({
                        title: 'Welcome',
                        message: "Login Successfuly",
                        color: "green",
                        position: "topRight",
                        balloon: true,
                        onOpened: function () {
                            document.location.href = response.uri

                        }
                    });

                } else if (response.response_code == "02") {


                    iziToast.show({
                        title: 'Verify Your Email',
                        message: "A verification message was sent to your email check your (Spam folder) if not found in Inbox",
                        color: "yellow",
                        position: "center",
                        balloon: true
                    });

                } else {
                    $('#login').prop('disabled', false)
                    iziToast.show({
                        title: 'Error',
                        message: response.message,
                        color: "red",
                        position: "topRight",
                        balloon: true
                    });
                    // $(".msg").html(`<div class='alert alert-danger alert-dismissible ' role='alert'>
                    //     <button type='button' class='close' data-dismiss='alert' aria-label='Close'><span
                    //     aria-hidden='true'>×</span>
                    //     </button><strong></strong>
                    //     ` + response.message + `
                    //     </div>`)
                }
                $('.msg').fadeIn('slow')
                $('.lds-ellipsis').fadeOut('slow')
            },

        })

    })
</script>

</html>