<?php

ini_set('memory_limit', -1);
require_once("../main_includes/init.php");
if (!isset($_GET['record'], $_SESSION['user_id'])) {
    redirect("../");
}
require('fpdf/fpdf.php');
// include('../includes/configpdo.php');
if (!isset($_GET['record'], $_SESSION['user_id'], $_GET['service_id'])) {
    redirect("../");
}

$user = User::find_by_id($_SESSION['user_id']);
if (!$user) {
    redirect("../");
}


$sub_service = SubService::find_by_id($_GET['service_id']);
if (!$sub_service) {
    redirect("../");
}

$service_fee = intval($sub_service->service_fee);
$status = 1;
$service = $sub_service->service_name;

$my_wallet = Wallet::find_by_query("SELECT * FROM wallet WHERE user_id =" . $user->id . " LIMIT 1");
$my_wallet = array_shift($my_wallet);
$my_wallet_balance = intval($my_wallet->balance);


$service_record = ServiceRecord::find_by_id($_GET['record']);
if (!$service_record) {

    redirect("../");
    return false;
}


$in_transaction = new InTransaction;

// $new_wallet_balance = $my_wallet_balance  - $service_fee;
// $my_wallet->balance = $new_wallet_balance;
// $my_wallet->date_updated = $date;
// $my_wallet->save();

$in_transaction->user_id = $user->id;
$in_transaction->wallet_id = $my_wallet->id;
$in_transaction->amount = $service_fee;
$in_transaction->remaining_balance = $my_wallet_balance;
$in_transaction->service_id = intval($sub_service->service_id);
$in_transaction->service = $service;
$in_transaction->date = $status == 1 ? $date : $in_transaction->date;
$in_transaction->status = $status;
$in_transaction->record_id = $service_record->id;
$in_transaction->search_query = $service_record->search_query;

// echo '<pre>';
// print_r($in_transaction);
// echo '</pre>';

if (!isset($_GET['redownload'])) {
$in_transaction->save();
}

$response_std = json_decode($service_record->response);

$vin = $response_std->data->vin != '' ? $response_std->data->vin : $service_record->search_query;

class PDF extends FPDF
{

    function Header()
    {
        // Select Arial bold 15
        $this->SetFont('Arial', 'B', 18);
        $this->SetTextColor(0);
        $this->SetDrawColor(0, 0, 155);
        $this->Ln(20);
        // $this->Cell(160, 7, 'National Identity Management System', 0, 1, 'C');

        $this->SetFont('Arial', 'B', 14);
        $this->Cell(160, 5, 'Federal Republic of Nigeria', 0, 1, 'C');
        $this->SetFont('Arial', '', 12);

        $this->SetTextColor(50, 50, 50);
        $this->Cell(160, 5, 'Voter\'s Identification Number (VIN) - Digital Identification', 0, 1, 'C');

        $this->Image('vin_logo.png', 150, 22, 22);
        // Line break 
        $this->Ln(2);
    }
    function Footer()
    {
        // Go to 0.9 cm from bottom
        // $this->SetY(-9);
        // $this->SetFont('Arial', 'I', 8);
        // Print centered page number
        // $this->Cell(0, 10, 'Page ' . $this->PageNo(), 0, 0, 'C');
    }
}



$filename = './tmp/t' . rand(00000000, 99999999) . '.jpeg';
if (file_exists($filename)) {
    unlink($filename);
}


$pdf = new PDF();


$pdf->AliasNbPages();
$pdf->AddPage('P', 'A4');
$pdf->SetFont('', '', 10);
$pdf->SetFillColor(255, 255, 255);

if($response_std->data->photo !=''){
    
    $img_o = base64_decode($response_std->data->photo);
    $img =  imagecreatefromstring($img_o);
    imagejpeg($img, $filename);
    $pdf->Image($filename, 10, 55, 60);
    
}
// print_r($response_std->data->signature);
// return false;


$pdf->Ln(6);
$pdf->SetDrawColor(150, 150, 150);
$pdf->SetFont('', 'B', 10);

$pdf->SetTextColor(120, 120, 120);
$pdf->Cell(75, 9, '', 0, 0, 'L', false);
$pdf->Cell(0, 9, 'Personal Information', 1, 1, 'C', false);

$pdf->SetFont('', '', 9);

$pdf->SetTextColor(100, 100, 100);
$pdf->Cell(75, 5, '', 0, 0, 'L', false);
$pdf->SetFont('', 'B', 9);
$pdf->Cell(49, 5, "Voter's Identification Number", "T L", 0, 'L', false);
$pdf->SetFont('', '', 9);
$pdf->Cell(0, 5, $vin, "T R", 1, 'L', false);

$pdf->Cell(75, 5, '', 0, 0, 'L', false);
$pdf->SetFont('', 'B', 9);
$pdf->Cell(49, 5, "(VIN)", "B L", 0, 'L', false);
$pdf->Cell(0, 5, '', 'B R', 1, 'L', false);

$pdf->Cell(75, 8, '', 0, 0, 'L', false);
$pdf->SetFont('', 'B', 9);
$pdf->Cell(49, 8, "First Name", "B L", 0, 'L', false);
$pdf->SetFont('', '', 9);
$pdf->Cell(0, 8, $response_std->data->firstname, "B R", 1, 'L', false);

// $pdf->Cell(75, 8, '', 0, 0, 'L', false);
// $pdf->SetFont('', 'B', 9);
// $pdf->Cell(49, 8, "Middle Name", "B L", 0, 'L', false);
// $pdf->SetFont('', '', 9);
// $pdf->Cell(0, 8, $response_std->data->middlename, "B R", 1, 'L', false);

$pdf->Cell(75, 8, '', 0, 0, 'L', false);
$pdf->SetFont('', 'B', 9);
$pdf->Cell(49, 8, "Last Name", "B L", 0, 'L', false);
$pdf->SetFont('', '', 9);
$pdf->Cell(0, 8, $response_std->data->surname??'', "B R", 1, 'L', false);

$pdf->Cell(75, 8, '', 0, 0, 'L', false);
$pdf->SetFont('', 'B', 9);
$pdf->Cell(49, 8, "Phone Number (1)", "B L", 0, 'L', false);
$pdf->SetFont('', '', 9);
$pdf->Cell(0, 8, $response_std->data->phone_number, "B R", 1, 'L', false);

$pdf->Cell(75, 8, '', 0, 0, 'L', false);
$pdf->SetFont('', 'B', 9);
$pdf->Cell(49, 8, "Phone Number (2)", "B L", 0, 'L', false);
$pdf->SetFont('', '', 9);
$pdf->Cell(0, 8, $response_std->data->phone_number2, "B R", 1, 'L', false);


$pdf->Cell(75, 8, '', 0, 0, 'L', false);
$pdf->SetFont('', 'B', 9);
$pdf->Cell(49, 8, "Year of birth", "B L", 0, 'L', false);
$pdf->SetFont('', '', 9);
$pdf->Cell(0, 8, $response_std->data->dob, "B R", 1, 'L', false);

$pdf->Cell(75, 8, '', 0, 0, 'L', false);
$pdf->SetFont('', 'B', 9);
$pdf->Cell(49, 8, "Gender", "B L", 0, 'L', false);
$pdf->SetFont('', '', 9);
$pdf->Cell(0, 8, strtoupper($response_std->data->gender), "B R", 1, 'L', false);

$pdf->Cell(75, 8, '', 0, 0, 'L', false);
$pdf->SetFont('', 'B', 9);
$pdf->Cell(49, 8, "Nationality", "B L", 0, 'L', false);
$pdf->SetFont('', '', 9);
$pdf->Cell(0, 8, $response_std->data->country, "B R", 1, 'L', false);

$pdf->Cell(75, 8, '', 0, 0, 'L', false);
$pdf->SetFont('', 'B', 9);
$pdf->Cell(49, 8, "State", "B L", 0, 'L', false);
$pdf->SetFont('', '', 9);
$pdf->Cell(0, 8, $response_std->data->state, "B R", 1, 'L', false);

$pdf->Cell(75, 8, '', 0, 0, 'L', false);
$pdf->SetFont('', 'B', 9);
$pdf->Cell(49, 8, "L.G.A", "B L", 0, 'L', false);
$pdf->SetFont('', '', 9);
$pdf->Cell(0, 8, $response_std->data->lga, "B R", 1, 'L', false);

$pdf->Cell(75, 8, '', 0, 0, 'L', false);
$pdf->SetFont('', 'B', 9);
$pdf->Cell(49, 8, "Occupation", "B L", 0, 'L', false);
$pdf->SetFont('', '', 9);
$pdf->Cell(0, 8, $response_std->data->occupation, "B R", 1, 'L', false);

$pdf->Cell(75, 12, '', 0, 0, 'L', false);
$pdf->SetFont('', 'B', 9);
$pdf->Cell(49, 12, "Address", "B L", 0, 'L', false);
$pdf->SetFont('', '', 9);

// $pdf->MultiCell(0, 6, $response_std->data->residence_address ??  $response_std->data->residence_AdressLine1 . ",\n" . $response_std->data->residence_town ?? $response_std->data->residence_Town . ",\n" . strtoupper($response_std->data->residence_state), "B R", 1, 'L', false);
$pdf->MultiCell(0, 6, $response_std->data->address, "B R T", 'L', false);


$pdf->Ln(10);
$pdf->MultiCell(0, 5, 'NOTE: ', 0, 'C', true);
if (file_exists($filename)) {
    unlink($filename);
}

// $pdf->Output();
$doc_name = $vin . "_personal_info_slip.pdf";
// $pdf->Output();
$pdf->Output("D", $doc_name);