<?php include "main_includes/header.php"; ?>


<body class="m-0 font-sans antialiased font-normal bg-white text-start text-base leading-default text-slate-500">
    <div class="container sticky top-0 z-sticky">
        <div class="flex flex-wrap -mx-3">
            <div class="w-full max-w-full px-3 flex-0">
                <!-- Navbar -->
                <nav
                    class="absolute top-0 left-0 right-0 z-30 flex flex-wrap items-center px-4 py-2 mx-6 my-4 shadow-soft-2xl rounded-blur bg-white/80 backdrop-blur-2xl backdrop-saturate-200 lg:flex-nowrap lg:justify-start">
                    <div class="flex items-center justify-between w-full p-0 pl-6 mx-auto flex-wrap-inherit">
                        <a class="py-2.375 text-sm mr-4 ml-4 whitespace-nowrap font-bold text-slate-700 lg:ml-0"
                            href="#">  </a>
                        <button navbar-trigger
                            class="px-3 py-1 ml-2 leading-none transition-all bg-transparent border border-transparent border-solid rounded-lg shadow-none cursor-pointer text-lg ease-soft-in-out lg:hidden"
                            type="button" aria-controls="navigation" aria-expanded="false"
                            aria-label="Toggle navigation">
                            <span
                                class="inline-block mt-2 align-middle bg-center bg-no-repeat bg-cover w-6 h-6 bg-none">
                                <span bar1
                                    class="w-5.5 rounded-xs relative my-0 mx-auto block h-px bg-gray-600 transition-all duration-300"></span>
                                <span bar2
                                    class="w-5.5 rounded-xs mt-1.75 relative my-0 mx-auto block h-px bg-gray-600 transition-all duration-300"></span>
                                <span bar3
                                    class="w-5.5 rounded-xs mt-1.75 relative my-0 mx-auto block h-px bg-gray-600 transition-all duration-300"></span>
                            </span>
                        </button>
                        <div navbar-menu
                            class="items-center flex-grow overflow-hidden transition-all duration-500 ease-soft lg-max:max-h-0 basis-full lg:flex lg:basis-auto">
                            <ul class="flex flex-col pl-0 mx-auto mb-0 list-none lg:flex-row xl:ml-auto">
                                <!-- <li>
                    <a class="flex items-center px-4 py-2 mr-2 font-normal transition-all lg-max:opacity-0 duration-250 ease-soft-in-out text-sm text-slate-700 lg:px-2" aria-current="page" href="pages/dashboard.html">
                      <i class="mr-1 fa fa-chart-pie opacity-60"></i>
                      Dashboard
                    </a>
                  </li> -->
                                <!-- <li>
                    <a class="block px-4 py-2 mr-2 font-normal transition-all lg-max:opacity-0 duration-250 ease-soft-in-out text-sm text-slate-700 lg:px-2" href="pages/profile.html">
                      <i class="mr-1 fa fa-user opacity-60"></i>
                      Profile
                    </a>
                  </li> -->
                                <li>
                                    <a class="block px-4 py-2 mr-2 font-normal transition-all lg-max:opacity-0 duration-250 ease-soft-in-out text-sm text-slate-700 lg:px-2"
                                        href="sign-up">
                                        <i class="mr-1 fas fa-user-circle opacity-60"></i>
                                        Sign Up
                                    </a>
                                </li>
                                <li>
                                    <a class="block px-4 py-2 mr-2 font-normal transition-all lg-max:opacity-0 duration-250 ease-soft-in-out text-sm text-slate-700 lg:px-2"
                                        href="sign-in">
                                        <i class="mr-1 fas fa-key opacity-60"></i>
                                        Sign In
                                    </a>
                                </li>
                            </ul>
                            <!-- online builder btn  -->
                            <!-- <li class="flex items-center">
                  <a
                    class="leading-pro ease-soft-in text-fuchsia-500 border-fuchsia-500 text-xs tracking-tight-soft bg-150 bg-x-25 rounded-3.5xl hover:border-fuchsia-500 hover:scale-102 hover:text-fuchsia-500 active:hover:border-fuchsia-500 active:hover:scale-102 active:hover:text-fuchsia-500 active:opacity-85 active:shadow-soft-xs active:bg-fuchsia-500 active:border-fuchsia-500 mr-2 mb-0 inline-block cursor-pointer border border-solid bg-transparent py-2 px-8 text-center align-middle font-bold uppercase shadow-none transition-all hover:bg-transparent hover:opacity-75 hover:shadow-none active:scale-100 active:text-white active:hover:bg-transparent active:hover:opacity-75 active:hover:shadow-none"
                    target="_blank"
                    href="https://www.creative-tim.com/builder/soft-ui?ref=navbar-dashboard&amp;_ga=2.76518741.1192788655.1647724933-1242940210.1644448053"
                    >Online Builder</a
                  >
                </li> -->
                            <ul class="hidden pl-0 mb-0 list-none lg:block lg:flex-row">
                                <li>
                                    <!-- <a href="https://www.creative-tim.com/product/soft-ui-dashboard-tailwind" target="_blank" class="leading-pro hover:scale-102 hover:shadow-soft-xs active:opacity-85 ease-soft-in text-xs tracking-tight-soft shadow-soft-md bg-150 bg-x-25 bg-gradient-to-tl from-gray-900 to-slate-800 rounded-3.5xl mb-0 mr-1 inline-block cursor-pointer border-0 bg-transparent px-8 py-2 text-center align-middle font-bold uppercase text-white transition-all">Free download</a> -->
                                </li>
                            </ul>
                        </div>
                    </div>
                </nav>
            </div>
        </div>
    </div>
    <main class="mt-0 transition-all duration-200 ease-soft-in-out">
        <section>
            <div class="relative flex items-center p-0 overflow-hidden bg-center bg-cover min-h-75-screen">
                <div class="container z-10">
                    <div class="flex flex-wrap mt-0 ml-16">
                        
                        <div class="lg:flex-0 shrink-0 md:w-6/12 relative">
                            <div
                                class="absolute top-0 hidden w-4/5 h-full mr-48 mt-12 overflow-hidden -right-40 rounded-bl-xl md:block">
                                <div class="absolute inset-x-0 top-0 z-0 h-full -ml-8 bg-cover skew-x-10"
                                    style="background-image: url('https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcSMFsz-XwtQinDjzYm0STf4M296jkEt8BFh2SQ8oTH4KXc0OBfZ-v-7eP6N_NXW3GpfO9E&usqp=CAU')"></div>
                            </div>
                        </div>
                        <div
                            class="flex flex-col w-full max-w-full px-3 mx-auto md:flex-0 shrink-0 md:w-6/12 lg:w-5/12 xl:w-4/12">
                            <div
                                class="relative flex flex-col min-w-0 mt-32 break-words bg-transparent border-0 shadow-none rounded-2xl bg-clip-border">
                                <div class="p-6 pb-0 mb-0 bg-transparent border-b-0 rounded-t-2xl">

                                    <h3
                                        class="relative z-10 font-bold text-transparent bg-gradient-to-tl from-blue-700 to-cyan-900 bg-clip-text">
                                        Welcome back</h3>
                                    <p class="mb-0">Enter your email and password to sign in</p>
                                    <div class="msg"></div>
                                </div>
                                <div class="flex-auto p-6">
                                    <form id="login_form" method="POST" role="form">
                                        <label class="mb-2 ml-1 font-bold text-xs text-slate-700">Email</label>
                                        <div class="mb-4">
                                            <input id="email" type="email" name="email"
                                                class="focus:shadow-soft-primary-outline text-sm leading-5.6 ease-soft block w-full appearance-none rounded-lg border border-solid border-gray-300 bg-white bg-clip-padding px-3 py-2 font-normal text-gray-700 transition-all focus:border-fuchsia-300 focus:outline-none focus:transition-shadow"
                                                placeholder="Email" aria-label="Email" aria-describedby="email-addon" />
                                        </div>
                                        <label class="mb-2 ml-1 font-bold text-xs text-slate-700">Password</label>
                                        <div class="mb-4">
                                            <input id="password" type="password"
                                                class="focus:shadow-soft-primary-outline text-sm leading-5.6 ease-soft block w-full appearance-none rounded-lg border border-solid border-gray-300 bg-white bg-clip-padding px-3 py-2 font-normal text-gray-700 transition-all focus:border-fuchsia-300 focus:outline-none focus:transition-shadow"
                                                placeholder="Password" name="password" aria-label="Password"
                                                aria-describedby="password-addon" />
                                        </div>
                                        <div class="min-h-6 mb-0.5 block pl-12">
                                            <input id="rememberMe"
                                                class="mt-0.54 rounded-10 duration-250 ease-soft-in-out after:rounded-circle after:shadow-soft-2xl after:duration-250 checked:after:translate-x-5.25 h-5 relative float-left -ml-12 w-10 cursor-pointer appearance-none border border-solid border-gray-200 bg-slate-800/10 bg-none bg-contain bg-left bg-no-repeat align-top transition-all after:absolute after:top-px after:h-4 after:w-4 after:translate-x-px after:bg-white after:content-[''] checked:border-slate-800/95 checked:bg-purple-800/95 checked:bg-none checked:bg-right"
                                                type="checkbox" checked="" />
                                            <label
                                                class="mb-2 ml-1 font-normal cursor-pointer select-none text-sm text-blue-900"
                                                for="rememberMe">Remember me</label>
                                        </div>
                                        <div class="text-center">
                                            <button type="submit" name="login" id="login"
                                                class="inline-block w-full px-6 py-3 mt-6 mb-0 font-bold text-center text-white uppercase align-middle transition-all bg-transparent border-0 rounded-lg cursor-pointer shadow-soft-md bg-x-25 bg-150 leading-pro text-xs ease-soft-in tracking-tight-soft bg-gradient-to-bl from-cyan-900 to-blue-900 hover:scale-102 hover:shadow-soft-xs active:opacity-85">Sign
                                                in </button>
                                        </div>
                                    </form>
                                </div>
                                <div
                                    class="p-2 px-1 pt-0 text-center bg-dark border-t-0 border-t-solid rounded-b-2xl lg:px-2">
                                    <p class="mx-auto leading-normal text-sm">
                                        Don't have an account?
                                        <a href="sign-up"
                                            class="relative z-10 font-semibold text-transparent bg-gradient-to-bl from-blue-900 to-blue-600 bg-clip-text">Sign
                                            up</a>
                                        <br>
                                        <!--<a href="forgot_password"-->
                                        <!--    class="relative z-10 font-semibold text-transparent bg-gradient-to-bl from-blue-900 to-cyan-900 bg-clip-text">Forgot-->
                                        <!--    Password</a>-->
                                    </p>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </main>
    <footer class="py-12">
        <div class="container">
            <div class="flex flex-wrap -mx-3">
                <div class="flex-shrink-0 w-full max-w-full mx-auto mb-6 text-center lg:flex-0 lg:w-8/12">
                    <!-- <a href="javascript:;" target="_blank" class="mb-2 mr-4 text-slate-400 sm:mb-0 xl:mr-12"> Company -->
                    <!-- </a> -->
                    <a href="javascript:;" target="_blank" class="mb-2 mr-4 text-slate-900 sm:mb-0 xl:mr-12"> About Us
                    </a>
                    <a href="javascript:;" target="_blank" class="mb-2 mr-4 text-slate-900 sm:mb-0 xl:mr-12"> Team </a>
                    <a href="javascript:;" target="_blank" class="mb-2 mr-4 text-slate-900 sm:mb-0 xl:mr-12"> Products
                    </a>
                    <!-- <a href="javascript:;" target="_blank" class="mb-2 mr-4 text-slate-400 sm:mb-0 xl:mr-12"> Blog </a> -->
                    <!-- <a href="javascript:;" target="_blank" class="mb-2 mr-4 text-slate-400 sm:mb-0 xl:mr-12"> Pricing -->
                    <!-- </a> -->
                </div>
                <div class="flex-shrink-0 w-full max-w-full mx-auto mt-2 mb-6 text-center flex flex-wrap justify-center">
                    <img src="https://speedydata.com.ng/home/outsource1/img/GLO-Airtime.jpg" class="h-14 mx-2 mb-2" alt="">
                    
                    <img src="https://speedydata.com.ng/home/outsource1/img/MTN-Airtime.jpg" class="h-14 mx-2 mb-2" alt="">
                    <img src="https://speedydata.com.ng/home/outsource1/img/Startimes-Subscription.jpg" class="h-14 mx-2 mb-2" alt="">
                    <img src="https://speedydata.com.ng/home/outsource1/img/Airtel-Airtime.jpg" class="h-14 mx-2 mb-2" alt="">

                </div>

            </div>
            <div class="flex flex-wrap -mx-3">
                <div class="w-8/12 max-w-full px-3 mx-auto mt-1 text-center flex-0">
                    <p class="mb-0 text-slate-400">
                        Copyright ©
                        <script>
                        document.write(new Date().getFullYear());
                        </script>
                        Soft by Confirm ID.
                    </p>
                </div>
            </div>
        </div>
    </footer>

</body>

<?php
include "./main_includes/loader_out.php";
?>
<!-- plugin for scrollbar  -->
<script src="assets/js/plugins/perfect-scrollbar.min.js" async></script>
<!-- main script file  -->
<script src="assets/js/soft-ui-dashboard-tailwind.js?v=1.0.4" async></script>
<script src="./assets/iziToast-master/dist/js/iziToast.js"></script>

<script>
    $(document).ready(function () {
        $('.lds-ellipsis').fadeOut('slow')
        $('#login').prop('disabled', false)
    })
    $(document).on("submit", "#login_form", function (e) {
        e.preventDefault()
        // console.log('ajajajaj')
        $('.msg').fadeOut('slow')
        $('.lds-ellipsis').fadeIn('slow')
        $('#login').prop('disabled', true)

        var email = $("#email").val()
        var password = $("#password").val()


        $.ajax({
            method: "POST",
            dataType: 'json',
            url: "main_includes/components/login.php",
            data: $(this).serialize(),
            success: function (response) {
                console.log(response)
                if (response.response_code == "00") {

                    $('#login').prop('disabled', false)
                    iziToast.show({
                        title: 'Welcome',
                        message: "Login Successfuly",
                        color: "green",
                        position: "topRight",
                        balloon: true,
                        onOpened: function () {
                            document.location.href = response.uri

                        }
                    });

                } else if (response.response_code == "02") {


                    iziToast.show({
                        title: 'Verify Your Email',
                        message: "A verification message was sent to your email check your (Spam folder) if not found in Inbox",
                        color: "yellow",
                        position: "center",
                        balloon: true
                    });

                } else {
                    $('#login').prop('disabled', false)
                    iziToast.show({
                        title: 'Error',
                        message: response.message,
                        color: "red",
                        position: "topRight",
                        balloon: true
                    });
                    // $(".msg").html(`<div class='alert alert-danger alert-dismissible ' role='alert'>
                    //     <button type='button' class='close' data-dismiss='alert' aria-label='Close'><span
                    //     aria-hidden='true'>×</span>
                    //     </button><strong></strong>
                    //     ` + response.message + `
                    //     </div>`)
                }
                $('.msg').fadeIn('slow')
                $('.lds-ellipsis').fadeOut('slow')
            },

        })

    })
</script>

</html>