<?php
$total = InTransaction::find_by_query("SELECT * FROM in_transaction WHERE user_id =$user->id ");
$total_success = InTransaction::find_by_query("SELECT * FROM in_transaction WHERE status = 1 AND user_id =$user->id ");
$total_failed = InTransaction::find_by_query("SELECT * FROM in_transaction WHERE status = 0 AND user_id =$user->id ");

$his_payments = Payment::find_by_query("SELECT * FROM payment WHERE user_id =$user->id ORDER BY id DESC LIMIT 3");
$total_topup = 0;
foreach ($his_payments as $his_payment) {

    $total_topup += intval($his_payment->amount);
}
?>



<div class="p-2 sm:ml-64 mb-14 bg-gray-200">
<nav class="md:max-w-max flex px-5 py-2 mt-20 mx-2 text-white border rounded-lg bg-red-600 border-gray-700"
        aria-label="Breadcrumb">
        <ol class="inline-flex items-center space-x-1 md:space-x-3">
            <li class="inline-flex items-center">
                <a href="<?= BASE_URL ?>"
                    class="inline-flex items-center text-sm font-medium text-white">
                    <svg class="w-3 h-3 mr-2.5" aria-hidden="true" xmlns="http://www.w3.org/2000/svg"
                        fill="currentColor" viewBox="0 0 20 20">
                        <path
                            d="m19.707 9.293-2-2-7-7a1 1 0 0 0-1.414 0l-7 7-2 2a1 1 0 0 0 1.414 1.414L2 10.414V18a2 2 0 0 0 2 2h3a1 1 0 0 0 1-1v-4a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1v4a1 1 0 0 0 1 1h3a2 2 0 0 0 2-2v-7.586l.293.293a1 1 0 0 0 1.414-1.414Z" />
                    </svg>
                    Home
                </a>
            </li>

        </ol>
    </nav>
    <div class="p-2 rounded-lg dark:border-gray-700">
    <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-4 ">
            <div class="flex flex-col rounded text-gray-100 p-4 h-full bg-blue-500 bg-red-900/90 shadow-sky-950 shadow-lg">
                <p class="flex items-center mb-3">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                        style="fill: rgb(205, 204, 204);transform: ;msFilter:;">
                        <path
                            d="M12 2a5 5 0 1 0 5 5 5 5 0 0 0-5-5zm0 8a3 3 0 1 1 3-3 3 3 0 0 1-3 3zm9 11v-1a7 7 0 0 0-7-7h-4a7 7 0 0 0-7 7v1h2v-1a5 5 0 0 1 5-5h4a5 5 0 0 1 5 5v1z">
                        </path>
                    </svg>
                    <span class="flex-1 ml-3 whitespace-nowrap text-sm">User Details</span>
                </p>
                <p class="font-bold text-sm">
                    <?= ($user->first_name . " " . $user->last_name) ?>
                </p>
                <p class="text-sm">
                    USER ID:
                    <?= md5($user->id) ?>
                </p>
            </div>
            <div>
                <div
                    class="flex items-center justify-between p-4 rounded h-full bg-blue-950/50 shadow-sky-950 shadow-lg">
                    <div>
                        <svg xmlns="http://www.w3.org/2000/svg" width="80" height="80" viewBox="0 0 24 24"
                            style="fill: rgb(255, 255, 255);transform: ;msFilter:;">
                            <path
                                d="M20 4H4c-1.103 0-2 .897-2 2v12c0 1.103.897 2 2 2h16c1.103 0 2-.897 2-2V6c0-1.103-.897-2-2-2zm-7.5 12a2.5 2.5 0 1 1 0-5 2.47 2.47 0 0 1 1.5.512c-.604.456-1 1.173-1 1.988s.396 1.532 1 1.988a2.47 2.47 0 0 1-1.5.512zm4 0a2.5 2.5 0 1 1 0-5 2.5 2.5 0 0 1 0 5z">
                            </path>
                        </svg>
                        <p class="font-bold text-2xl text-white">₦
                            <?= number_format($wallet->balance) ?>
                        </p>
                    </div>
                    <div class="flex items-center rounded-xl h-28 ">

                        <a href="./wallet"
                            class="rounded-lg text-white border px-5 py-2 text-sm md:py-3 hover:bg-gray-700 hover:scale-105 transition-all  bg-red-950/50">Fund
                            Wallet</a>
                    </div>
                </div>

            </div>
        </div>

        <h3 class="text-blue-400 text-sm">Services</h3>

        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4 items-center justify-center rounded py-4 ">
        <!-- <a href="<?= BASE_URL ?>/verifications/-nin_verifications" -->
        <a data-modal-target="crud-modal" data-modal-toggle="crud-modal" href="#"
                class="flex flex-col h-auto py-2 px-4 text-cyan-800 bg-white transition-all shadow-gray-500 shadow-md rounded w-full hover:text-gray-500">
                <div class="flex">
                    <div class="w-2/4 flex">
                        <div>
                        <img src="https://www.alrahuzdata.com.ng/static/dashboard/assets/img/airtime.svg" alt="Cell Phone SVG Icon" class="h-24 w-auto">

                        </div>
                        
                        <span class="font-bold mt-8 ml-4" >Airtime TopUp</span>
                     
                    </div>
                    <div class="w-2/4 flex justify-end text-[0.8rem] font-bold">
                        <div class="text-right">

                        </div>
                    </div>

                </div>
  <!-- <div class="flex flex-col my-3">
                    <span class="text-xs">Verify people using their National Identity Number.</span>
                </div> -->
                <div class="flex justify-between mt-2">
                    <div class="text-right">
                        <span class="text-sm bg-cyan-800 text-white rounded py-1 px-2 hover:scale-105">Use
                            Service</span>

                    </div>

                </div>
                
            </a>
                

<!-- Modal toggle -->
<!-- <button data-modal-target="crud-modal" data-modal-toggle="crud-modal" class="block text-white bg-blue-700 hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 font-medium rounded-lg text-sm px-5 py-2.5 text-center dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800" type="button">
  Toggle modal
</button> -->

<!-- Main modal Airtime -->
<div id="crud-modal" tabindex="-1" aria-hidden="true" class="hidden overflow-y-auto overflow-x-hidden fixed top-0 right-0 left-0 z-50 justify-center items-center w-full md:inset-0 h-[calc(100%-1rem)] max-h-full">
    <div class="relative p-4 w-full max-w-md max-h-full">
        <!-- Modal content -->
        <div class="relative bg-purple-800 rounded-lg shadow dark:bg-purple-800">
            <!-- Modal header -->
            <div class="flex items-center justify-between p-4 md:p-5 border-b rounded-t dark:border-gray-600">
                <h3 class="text-lg font-semibold text-gray-900 dark:text-white">
                    Buy Airtime
                </h3>
                <button type="button" class="text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm w-8 h-8 ms-auto inline-flex justify-center items-center dark:hover:bg-gray-600 dark:hover:text-white" data-modal-toggle="crud-modal">
                    <svg class="w-3 h-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 14 14">
                        <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m1 1 6 6m0 0 6 6M7 7l6-6M7 7l-6 6"/>
                    </svg>
                    <span class="sr-only">Close modal</span>
                </button>
            </div>
            <!-- Modal body -->
            <form class="p-4 md:p-5">
                <div class="grid gap-4 mb-4 grid-cols-2">
                    <div class="col-span-2">
                        <label for="name" class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">Phone Number</label>
                        <input type="number" name="name" id="name" class="bg-white border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-white dark:border-gray-500 dark:placeholder-gray-400 dark:text-gray dark:focus:ring-primary-500 dark:focus:border-primary-500" placeholder="e.g 08100000000" required="">
                    </div>
                    <div class="col-span-2 sm:col-span-1">
                        <label for="price" class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">Price</label>
                        <input type="number" name="price" id="price" class="bg-white border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-white dark:border-gray-500 dark:placeholder-gray-400 dark:text-gray dark:focus:ring-primary-500 dark:focus:border-primary-500" placeholder="N100 - N20000" required="">
                    </div>
                    <div class="col-span-2 sm:col-span-1">
                        <label for="category" class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">Network</label>
                        <select id="category" class="bg-white border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5 dark:bg-gray-600 dark:border-gray-500 dark:placeholder-gray-400 dark:text-gray dark:focus:ring-primary-500 dark:focus:border-primary-500">
                            <option selected="">Select Network</option>
                            <option value="TV">MTN</option>
                            <option value="PC">Airtime</option>
                            <option value="GA">GLO</option>
                            <option value="PH">9Mobile</option>
                        </select>
                    </div>
                </div>
                <button type="submit" class="text-white inline-flex items-center bg-blue-700 hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 font-medium rounded-lg text-sm px-5 py-2.5 text-center dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">
                    Buy Airtime
                </button>
            </form>
        </div>
    </div>
</div> 
     
            <a href="#" data-modal-target="data-modal" data-modal-toggle="data-modal"
                class="flex flex-col h-auto py-2 px-4 text-cyan-800 bg-white transition-all shadow-gray-500 shadow-md rounded w-full hover:text-gray-500">
                <div class="flex"> 
                    <div class="w-2/4 flex">
                        <div>
                        <img src="https://www.alrahuzdata.com.ng/static/dashboard/assets/img/data.jpg" alt="Cell Phone SVG Icon" class="h-24 w-auto">

                        </div>
                        
                        <span class="font-bold mt-8" >Buy Data</span>
                     
                    </div>
                    <div class="w-2/4 flex justify-end text-[0.8rem] font-bold">
                        <div class="text-right">

                        </div>
                    </div>

                </div>

                
                <!-- <div class="flex flex-col my-3">
                    <span class="text-xs">Verify people using their National Identity Number.</span>
                </div> -->
                <div class="flex justify-between mt-2">
                    <div class="text-right">
                        <span class="text-sm bg-cyan-800 text-white rounded py-1 px-2 hover:scale-105">Use
                            Service</span>

                    </div>

                </div>
            </a>

<!-- Notification Modals -->
<!-- BVN length validation error -->
<div id="bvnLengthErrorModal" class="modal hidden ">
    <div class="modal-content bg-red-100 border-l-4 border-red-500 text-red-700 p-2 max-w-xs mx-auto style="margin-top: 12px;">
        <span class="close">&times;</span>
        <p id="bvnLengthErrorMessage">BVN length must be 11</p>
    </div>
</div>

<!-- Existing BVN notification -->
<div id="existingBVNModal" class="modal hidden">
    <div class="modal-content bg-red-100 border-l-4 border-red-500 text-red-700 p-4 max-w-xs mx-auto my-2">
        <span class="close">&times;</span>
        <p id="existingBVNMessage">This BVN already exists</p>
    </div>
</div>

<!-- Successful insertion notification -->
<div id="insertionSuccessModal" class="modal hidden">
    <div class="modal-content bg-green-100 border-l-4 border-green-500 text-green-700 p-4 max-w-xs mx-auto my-2">
        <span class="close">&times;</span>
        <p id="insertionSuccessMessage">BVN added successfully</p>
    </div>
</div>



       
    
    <!-- BVN modal -->
    <!--<div class="modal-overlay fixed top-0 right-0 bottom-0 left-0 bg-black opacity-50 z-40"></div>-->

<div id="authentication-modal" tabindex="-1" aria-hidden="true" class="hidden fixed inset-0 z-50 flex items-center justify-center">
    <div class="absolute inset-0 bg-black opacity-45"></div>
    <div class="relative p-4 w-full max-w-md max-h-full">
        <!-- Modal content -->
        <div class="relative bg-white rounded-lg shadow dark:bg-gray-700">
            <!-- Modal header -->
            <div class="flex items-center justify-between p-4 md:p-5 border-b rounded-t dark:border-gray-600">
                <h3 class="text-xl font-semibold text-gray-600 dark:text-gray-600">
                    Provide your BVN
                </h3>
                <button type="button" class="end-2.5 text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm w-8 h-8 ms-auto inline-flex justify-center items-center dark:hover:bg-gray-600 dark:hover:text-white" data-modal-hide="authentication-modal">
                    <svg class="w-3 h-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 14 14">
                        <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m1 1 6 6m0 0 6 6M7 7l6-6M7 7l-6 6"/>
                    </svg>
                    <span class="sr-only">Close modal</span>
                </button>
            </div>
            <!-- Modal body -->
            <div class="p-4 md:p-5">
                <form class="space-y-4" method="POST" action="#">
                    <div>
                        <label for="bvn" class="block mb-2 text-sm font-medium text-gray-600 dark:text-gray-600">Your BVN</label>
                        <input type="text" name="bvn" id="bvn" class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-gray-600 dark:border-gray-500 dark:placeholder-gray-400 dark:text-white" placeholder="12345678901" required />
                    </div>
                    <button type="submit" class="w-full text-white bg-blue-700 hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 font-medium rounded-lg text-sm px-5 py-2.5 text-center dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">Submit</button>
                </form>
            </div>
        </div>
    </div>
</div>




            <!-- Main modal for Data -->
<div id="data-modal" tabindex="-1" aria-hidden="true" class="hidden overflow-y-auto overflow-x-hidden fixed top-0 right-0 left-0 z-50 justify-center items-center w-full md:inset-0 h-[calc(100%-1rem)] max-h-full">
    <div class="relative p-4 w-full max-w-md max-h-full">
        <!-- Modal content -->
        <div class="relative bg-purple-800 rounded-lg shadow dark:bg-purple-800">
            <!-- Modal header -->
            <div class="flex items-center justify-between p-4 md:p-5 border-b rounded-t dark:border-gray-600">
                <h3 class="text-lg font-semibold text-gray-900 dark:text-white">
                    Buy Data
                </h3>
                <button type="button" class="text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm w-8 h-8 ms-auto inline-flex justify-center items-center dark:hover:bg-gray-600 dark:hover:text-white" data-modal-toggle="data-modal">
                    <svg class="w-3 h-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 14 14">
                        <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m1 1 6 6m0 0 6 6M7 7l6-6M7 7l-6 6"/>
                    </svg>
                    <span class="sr-only">Close modal</span>
                </button>
            </div>
            <!-- Modal body -->
            <form class="p-4 md:p-5">
                <div class="grid gap-4 mb-4 grid-cols-2">
                    <div class="col-span-2">
                        <label for="name" class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">Phone Number</label>
                        <input type="number" name="name" id="name" class="bg-white border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-white dark:border-gray-500 dark:placeholder-gray-400 dark:text-gray dark:focus:ring-primary-500 dark:focus:border-primary-500" placeholder="e.g 08100000000" required="">
                    </div>
                    <div class="col-span-2 sm:col-span-1">
                        <label for="category" class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">Amount</label>
                        <select id="category" class="bg-white border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5 dark:bg-gray-600 dark:border-gray-500 dark:placeholder-gray-400 dark:text-gray dark:focus:ring-primary-500 dark:focus:border-primary-500">
                            <option selected="">500MB - 20GB</option>
                            <option value="TV">500MB</option>
                            <option value="PC">1GB</option>
                            <option value="GA">2GB</option>
                            <option value="PH">3GB</option>
                            <option value="PH">4GB</option>
                        </select>
                    </div>
                    <div class="col-span-2 sm:col-span-1">
                        <label for="category" class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">Network</label>
                        <select id="category" class="bg-white border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5 dark:bg-gray-600 dark:border-gray-500 dark:placeholder-gray-400 dark:text-gray dark:focus:ring-primary-500 dark:focus:border-primary-500">
                            <option selected="">Select Network</option>
                            <option value="TV">MTN</option>
                            <option value="PC">Airtime</option>
                            <option value="GA">GLO</option>
                            <option value="PH">9Mobile</option>
                        </select>
                    </div>
                </div>
                <button type="submit" class="text-white inline-flex items-center bg-blue-700 hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 font-medium rounded-lg text-sm px-5 py-2.5 text-center dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">
                    Buy Data
                </button>
            </form>
        </div>
    </div>
</div> 


            <a  href="#" data-modal-target="cash-modal" data-modal-toggle="cash-modal"
                class="flex flex-col h-auto py-2 px-4 text-cyan-800 bg-white transition-all shadow-gray-500 shadow-md rounded w-full hover:text-gray-500">
                <div class="flex">
                    <div class="w-2/4 flex">
                        <div>
                        <img src="https://www.alrahuzdata.com.ng/static/dashboard/assets/img/airtime2cash.jpg" alt="Cell Phone SVG Icon" class="h-24 w-auto">

                        </div>
                        
                        <span class="font-bold mt-8" >Airtime to Cash</span>
                     
                    </div>
                    <div class="w-2/4 flex justify-end text-[0.8rem] font-bold">
                        <div class="text-right">

                        </div>
                    </div>

                </div>

                
                <!-- <div class="flex flex-col my-3">
                    <span class="text-xs">Verify people using their National Identity Number.</span>
                </div> -->
                <div class="flex justify-between mt-2">
                    <div class="text-right">
                        <span class="text-sm bg-cyan-800 text-white rounded py-1 px-2 hover:scale-105">Use
                            Service</span>

                    </div>

                </div>
                
            </a>
            <!-- Main modal Airtime -->
<div id="cash-modal" tabindex="-1" aria-hidden="true" class="hidden overflow-y-auto overflow-x-hidden fixed top-0 right-0 left-0 z-50 justify-center items-center w-full md:inset-0 h-[calc(100%-1rem)] max-h-full">
    <div class="relative p-4 w-full max-w-md max-h-full">
        <!-- Modal content -->
        <div class="relative bg-purple-800 rounded-lg shadow dark:bg-purple-800">
            <!-- Modal header -->
            <div class="flex items-center justify-between p-4 md:p-5 border-b rounded-t dark:border-gray-600">
                <h3 class="text-lg font-semibold text-gray-900 dark:text-white">
                    Airtime to Cash
                </h3>
                <button type="button" class="text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm w-8 h-8 ms-auto inline-flex justify-center items-center dark:hover:bg-gray-600 dark:hover:text-white" data-modal-toggle="cash-modal">
                    <svg class="w-3 h-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 14 14">
                        <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m1 1 6 6m0 0 6 6M7 7l6-6M7 7l-6 6"/>
                    </svg>
                    <span class="sr-only">Close modal</span>
                </button>
            </div>
            <!-- Modal body -->
            <form class="p-4 md:p-5">
                <div class="grid gap-4 mb-4 grid-cols-2">
                    <div class="col-span-2">
                        <label for="name" class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">Phone Number</label>
                        <input type="number" name="name" id="name" class="bg-white border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-white dark:border-gray-500 dark:placeholder-gray-400 dark:text-gray dark:focus:ring-primary-500 dark:focus:border-primary-500" placeholder="e.g 08100000000" required="">
                    </div>
                    <div class="col-span-2 sm:col-span-1">
                        <label for="price" class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">Price</label>
                        <input type="number" name="price" id="price" class="bg-white border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-white dark:border-gray-500 dark:placeholder-gray-400 dark:text-gray dark:focus:ring-primary-500 dark:focus:border-primary-500" placeholder="N100 - N20000" required="">
                    </div>
                    <div class="col-span-2 sm:col-span-1">
                        <label for="price" class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">Acc. No.</label>
                        <input type="number" name="price" id="price" class="bg-white border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-white dark:border-gray-500 dark:placeholder-gray-400 dark:text-gray dark:focus:ring-primary-500 dark:focus:border-primary-500" placeholder="N100 - N20000" required="">
                    </div>
                    <div class="col-span-2 sm:col-span-1">
                        <label for="price" class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">Bank</label>
                        <input type="text" name="price" id="price" class="bg-white border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-white dark:border-gray-500 dark:placeholder-gray-400 dark:text-gray dark:focus:ring-primary-500 dark:focus:border-primary-500" placeholder="e.g Access Bank" required="">
                    </div>
                    <div class="col-span-2 sm:col-span-1">
                        <label for="category" class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">Network</label>
                        <select id="category" class="bg-white border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5 dark:bg-gray-600 dark:border-gray-500 dark:placeholder-gray-400 dark:text-gray dark:focus:ring-primary-500 dark:focus:border-primary-500">
                            <option selected="">Select Network</option>
                            <option value="TV">MTN</option>
                            <option value="PC">Airtime</option>
                            <option value="GA">GLO</option>
                            <option value="PH">9Mobile</option>
                        </select>
                    </div>
                </div>
                <button type="submit" class="text-white inline-flex items-center bg-blue-700 hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 font-medium rounded-lg text-sm px-5 py-2.5 text-center dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">
                    Send
                </button>
            </form>
        </div>
    </div>
</div> 
            <a href="#"
                class="flex flex-col h-auto py-2 px-4 text-cyan-800 bg-white transition-all shadow-gray-500 shadow-md rounded w-full hover:text-gray-500">
                <div class="flex">
                    <div class="w-2/4 flex">
                        <div>
                        <img src="	https://www.alrahuzdata.com.ng/static/dashboard/assets/img/cable.jpg" alt="Cell Phone SVG Icon" class="h-24 w-auto">

                        </div>
                        
                        <span class="font-bold mt-8" >Cable Sub</span>
                     
                    </div>
                    <div class="w-2/4 flex justify-end text-[0.8rem] font-bold">
                        <div class="text-right">

                        </div>
                    </div>

                </div>

                
                <!-- <div class="flex flex-col my-3">
                    <span class="text-xs">Verify people using their National Identity Number.</span>
                </div> -->
                <div class="flex justify-between mt-2">
                    <div class="text-right">
                        <span class="text-sm bg-cyan-800 text-white rounded py-1 px-2 hover:scale-105">Use
                            Service</span>

                    </div>

                </div>
                
            </a>
            <a href="#"
                class="flex flex-col h-auto py-2 px-4 text-cyan-800 bg-white transition-all shadow-gray-500 shadow-md rounded w-full hover:text-gray-500">
                <div class="flex">
                    <div class="w-2/4 flex">
                        <div>
                        <img src="https://www.alrahuzdata.com.ng/static/dashboard/assets/img/utility.jpg" alt="Cell Phone SVG Icon" class="h-24 w-auto">

                        </div>
                        
                        <span class="font-bold mt-8" >Electricity Bill</span>
                     
                    </div>
                    <div class="w-2/4 flex justify-end text-[0.8rem] font-bold">
                        <div class="text-right">

                        </div>
                    </div>

                </div>

                
                <!-- <div class="flex flex-col my-3">
                    <span class="text-xs">Verify people using their National Identity Number.</span>
                </div> -->
                <div class="flex justify-between mt-2">
                    <div class="text-right">
                        <span class="text-sm bg-cyan-800 text-white rounded py-1 px-2 hover:scale-105">Use
                            Service</span>

                    </div>

                </div>
                
            </a>
            <a href="# "
                class="flex flex-col h-auto py-2 px-4 text-cyan-800 bg-white transition-all shadow-gray-500 shadow-md rounded w-full hover:text-gray-500">
                <div class="flex">
                    <div class="w-2/4 flex">
                        <div>
                        <img src="https://www.alrahuzdata.com.ng/static/dashboard/assets/img/resultchecker.png" alt="Cell Phone SVG Icon" class="h-24 w-auto">

                        </div>
                        
                        <span class="font-bold mt-8" >Result Checker</span>
                     
                    </div>
                    <div class="w-2/4 flex justify-end text-[0.8rem] font-bold">
                        <div class="text-right">

                        </div>
                    </div>

                </div>

                
                <!-- <div class="flex flex-col my-3">
                    <span class="text-xs">Verify people using their National Identity Number.</span>
                </div> -->
                <div class="flex justify-between mt-2">
                    <div class="text-right">
                        <span class="text-sm bg-cyan-800 text-white rounded py-1 px-2 hover:scale-105">Use
                            Service</span>

                    </div>

                </div>
                
            </a>


        </div>

        <h3 class="text-gray-400 text-sm">Transactions</h3>

        <div
            class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-4 items-center justify-center rounded py-4 ">

            <?php foreach ($his_payments as $his_payment): ?>
                <div
                    class="flex flex-col h-auto mb-2 p-2 text-cyan-800 bg-sky-200 hover:scale-y-105 transition-all shadow-sky-900 shadow-md rounded w-full cursor-pointer">
                    <div class="flex">
                        <div class="w-3/4 flex">

                            <div class="rounded-full bg-white p-2 w-10 h-10 flex items-center justify-center mr-3">
                                <svg xmlns="http://www.w3.org/2000/svg" width="30" height="30" viewBox="0 0 24 24"
                                    style="fill: #0b9152;transform: ;msFilter:;">
                                    <path
                                        d="M8 12.052c1.995 0 3.5-1.505 3.5-3.5s-1.505-3.5-3.5-3.5-3.5 1.505-3.5 3.5 1.505 3.5 3.5 3.5zM9 13H7c-2.757 0-5 2.243-5 5v1h12v-1c0-2.757-2.243-5-5-5zm11.294-4.708-4.3 4.292-1.292-1.292-1.414 1.414 2.706 2.704 5.712-5.702z">
                                    </path>
                                </svg>
                            </div>

                            <div class="flex flex-col">
                                <span class="font-bold text-sm">Wallet Top-up</span>
                                <span class="text-xs">
                                    TRX-
                                    <?= $his_payment->reference ?><br>
                                    <?= $his_payment->date_created ?>
                                </span>
                            </div>
                        </div>
                        <div class="w-1/4 flex justify-end text-[#0f5132] text-[0.8rem] font-bold">
                            + ₦
                            <?= number_format($his_payment->amount) ?>
                        </div>
                    </div>
                    <div class="text-right">
                        <span class=" bg-[#d1e7dd] border border-[#badbcc] px-5 rounded text-[#0f5132] text-xs py-1 ">
                            Successful
                        </span>
                    </div>

                </div>
            <?php endforeach ?>

        </div>

        <a href="<?= BASE_URL ?>/transactions"
            class="text-white mt-2 border w-full md:max-w-max lg:max-w-max bg-cyan-800 rounded-xl py-2 px-4 md:px-14 hover:scale-105">More</a>
            <img src="verifyall-2.png" alt="">
    </div>
    <section class="mt-3 md:mt-10 mx-2 md:mx-24">
        <h1 class="mb-3 md:mb-10 text-base md:text-xl text-brand font-bold">
            Our data price list
        </h1>
        <!--Pricing Grid-->
        <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-2 lg:grid-cols-4 gap-5 ml-4 bg-white">
            
            <!--MTN-->
            <div class=" flex flex-col border-[1.5px] border-yellow-400 rounded-md shadow">
                <!--Image-->
                <div class="flex justify-center items-center py-2">
                    <img src="https://speedydata.com.ng/home/outsource1/img/MTN-Airtime.jpg" class="img-fluid max-w-[4rem]" alt="">
                </div>
                <!--Image-->
                <!--Items-->
                <div class="block py-2">
                    <ul class="px-3 list-none space-y-3">
                    	                    	                        <li class="flex justify-between pb-3 bg-brand-light p-2 rounded-md">
                            <span class="">1GB</span>
                            <span class="flex flex-col">
                                <span class="">₦300</span>
                            </span>
                        </li>
                                            	                        <li class="flex justify-between pb-3 bg-brand-light p-2 rounded-md">
                            <span class="">2GB</span>
                            <span class="flex flex-col">
                                <span class="">₦600</span>
                            </span>
                        </li>
                                            	                        <li class="flex justify-between pb-3 bg-brand-light p-2 rounded-md">
                            <span class="">3GB</span>
                            <span class="flex flex-col">
                                <span class="">₦900</span>
                            </span>
                        </li>
                                            	                        <li class="flex justify-between pb-3 bg-brand-light p-2 rounded-md">
                            <span class="">4GB</span>
                            <span class="flex flex-col">
                                <span class="">₦1,200</span>
                            </span>
                        </li>
                                            	                        <li class="flex justify-between pb-3 bg-brand-light p-2 rounded-md">
                            <span class="">5GB</span>
                            <span class="flex flex-col">
                                <span class="">₦1,500</span>
                            </span>
                        </li>
                                            	                        <li class="flex justify-between pb-3 bg-brand-light p-2 rounded-md">
                            <span class="">10GB</span>
                            <span class="flex flex-col">
                                <span class="">₦3,000</span>
                            </span>
                        </li>
                                            	                        <li class="flex justify-between pb-3 bg-brand-light p-2 rounded-md">
                            <span class="">15GB</span>
                            <span class="flex flex-col">
                                <span class="">₦4,400</span>
                            </span>
                        </li>
                                            	                        <li class="flex justify-between pb-3 bg-brand-light p-2 rounded-md">
                            <span class="">20GB</span>
                            <span class="flex flex-col">
                                <span class="">₦5,900</span>
                            </span>
                        </li>
                                            	                    	                    	                    	                    	                    	                    	                    	                    	                    	                    	                    	                    	                    	                    	                    </ul>
                </div>
                <!--Items-->
            </div>
            
                <!-- Glo -->
            <div class="flex flex-col border-[1.5px] border-green-500 rounded-md shadow">
                <!--Image-->
                <div class="flex justify-center items-center py-2">
                    <img src="https://speedydata.com.ng/home/outsource1/img/GLO-Airtime.jpg" class="img-fluid max-w-[4rem]" alt="">
                </div>
                <!--Image-->
                <!--Items-->
                <div class="block py-2">
                    <ul class="px-3 list-none space-y-3">
                    	                    	                    	                    	                    	                    	                    	                    	                    	                    	                    	                    	                    	                    	                    	                    	                        <li class="flex justify-between pb-3 bg-brand-light p-2 rounded-md">
                            <span class="">1GB</span>
                            <span class="flex flex-col">
                                <span class="">₦350</span>
                            </span>
                        </li>
                                            	                        <li class="flex justify-between pb-3 bg-brand-light p-2 rounded-md">
                            <span class="">2GB</span>
                            <span class="flex flex-col">
                                <span class="">₦700</span>
                            </span>
                        </li>
                                            	                        <li class="flex justify-between pb-3 bg-brand-light p-2 rounded-md">
                            <span class="">7.5GB</span>
                            <span class="flex flex-col">
                                <span class="">₦1,350</span>
                            </span>
                        </li>
                                            	                        <li class="flex justify-between pb-3 bg-brand-light p-2 rounded-md">
                            <span class="">9.2GB</span>
                            <span class="flex flex-col">
                                <span class="">₦1,800</span>
                            </span>
                        </li>
                                            	                        <li class="flex justify-between pb-3 bg-brand-light p-2 rounded-md">
                            <span class="">10.8GB</span>
                            <span class="flex flex-col">
                                <span class="">₦2,250</span>
                            </span>
                        </li>
                                            	                    	                    	                    	                    </ul>
                </div>
            </div>
             <!--9MOBILE-->
             <div class="flex flex-col border-[1.5px] border-green-700 rounded-md shadow">
                <!--Image-->
                <div class="flex justify-center items-center py-2">
                    <img src="https://speedydata.com.ng/home/outsource1/img/9mobile-Airtime.jpg" class="img-fluid max-w-[4rem]" alt="">
                </div>
                <!--Image-->
                <!--Items-->
                <div class="block py-2">
                    <ul class="px-3 list-none space-y-3">
                    	                    	                    	                    	                    	                    	                    	                    	                    	                    	                    	                    	                    	                    	                    	                    	                    	                    	                    	                    	                    	                        <li class="flex justify-between pb-3 bg-brand-light p-2 rounded-md">
                            <span class="">1.5GB</span>
                            <span class="flex flex-col">
                                <span class="">₦850</span>
                            </span>
                        </li>
                                            	                        <li class="flex justify-between pb-3 bg-brand-light p-2 rounded-md">
                            <span class="">4.5GB</span>
                            <span class="flex flex-col">
                                <span class="">₦1,700</span>
                            </span>
                        </li>
                                            	                        <li class="flex justify-between pb-3 bg-brand-light p-2 rounded-md">
                            <span class="">11GB</span>
                            <span class="flex flex-col">
                                <span class="">₦3,400</span>
                            </span>
                        </li>
                                            	                        <li class="flex justify-between pb-3 bg-brand-light p-2 rounded-md">
                            <span class="">15GB</span>
                            <span class="flex flex-col">
                                <span class="">₦4,400</span>
                            </span>
                        </li>
                                            </ul>
                </div>
                <!--Items-->
            </div>
            <!--9MOBILE-->

            <!--AIRTEL-->
            <div class="flex flex-col border-[1.5px] border-red-700 rounded-md shadow">
                <!--Image-->
                <div class="flex justify-center items-center py-2">
                    <img src="https://speedydata.com.ng/home/outsource1/img/Airtel-Airtime.jpg" class="img-fluid max-w-[4rem]" alt="">
                </div>
                <!--Image-->
                <!--Items-->
                <div class="block py-2">
                    <ul class="px-3 list-none space-y-3">
                    	                    	                    	                    	                    	                    	                    	                    	                    	                    	                        <li class="flex justify-between pb-3 bg-brand-light p-2 rounded-md">
                            <span class="">1GB</span>
                            <span class="flex flex-col">
                                <span class="">₦350</span>
                            </span>
                        </li>
                                            	                        <li class="flex justify-between pb-3 bg-brand-light p-2 rounded-md">
                            <span class="">2GB</span>
                            <span class="flex flex-col">
                                <span class="">₦700</span>
                            </span>
                        </li>
                                            	                        <li class="flex justify-between pb-3 bg-brand-light p-2 rounded-md">
                            <span class="">5GB</span>
                            <span class="flex flex-col">
                                <span class="">₦1,500</span>
                            </span>
                        </li>
                                            	                        <li class="flex justify-between pb-3 bg-brand-light p-2 rounded-md">
                            <span class="">10GB</span>
                            <span class="flex flex-col">
                                <span class="">₦2,700</span>
                            </span>
                        </li>
                                            	                        <li class="flex justify-between pb-3 bg-brand-light p-2 rounded-md">
                            <span class="">15GB</span>
                            <span class="flex flex-col">
                                <span class="">₦4,500</span>
                            </span>
                        </li>
                                            	                        <li class="flex justify-between pb-3 bg-brand-light p-2 rounded-md">
                            <span class="">20GB</span>
                            <span class="flex flex-col">
                                <span class="">₦5,500</span>
                            </span>
                        </li>
                              </ul>
                </div>
                <!--Items-->
            </div>
            <!--AIRTEL-->
        </div>
    </section>
</div>

    <script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>



<script>
   document.addEventListener('DOMContentLoaded', function () {
        // ... existing code ...

        // Check if there is a BVN validation error
        if (typeof bvnValidationError !== 'undefined' && bvnValidationError) {
            openNotificationModal("bvnLengthErrorModal", "BVN must be 11 digits.");
        }

        // Check if BVN already exists
        if (typeof existingBVN !== 'undefined' && existingBVN) {
            openNotificationModal("existingBVNModal", "This BVN already exists!");
            existingBVN = undefined;

        }

        // Check if BVN insertion is successful
        if (typeof insertionSuccess !== 'undefined' && insertionSuccess) {
            openNotificationModal("insertionSuccessModal", "BVN inserted successfully!");
        }

        
    });

</script>







